/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.campaignmanagement.AdGroupCriterionStatus;
import com.microsoft.bingads.v12.campaignmanagement.LocationCriterion;
import com.microsoft.bingads.v12.campaignmanagement.NegativeAdGroupCriterion;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import com.microsoft.bingads.v12.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupNegativeLocationCriterion
extends SingleRecordBulkEntity {
    private NegativeAdGroupCriterion negativeAdGroupCriterion;
    private String campaignName;
    private String adGroupName;
    private static final List<BulkMapping<BulkAdGroupNegativeLocationCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        NegativeAdGroupCriterion adGroupCriterion = new NegativeAdGroupCriterion();
        LocationCriterion locationCriterion = new LocationCriterion();
        adGroupCriterion.setCriterion(locationCriterion);
        adGroupCriterion.getCriterion().setType(LocationCriterion.class.getSimpleName());
        adGroupCriterion.setType("NegativeAdGroupCriterion");
        this.setNegativeAdGroupCriterion(adGroupCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getNegativeAdGroupCriterion(), NegativeAdGroupCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public NegativeAdGroupCriterion getNegativeAdGroupCriterion() {
        return this.negativeAdGroupCriterion;
    }

    public void setNegativeAdGroupCriterion(NegativeAdGroupCriterion negativeAdGroupCriterion) {
        this.negativeAdGroupCriterion = negativeAdGroupCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setAdGroupName(String adGroupName) {
        this.adGroupName = adGroupName;
    }

    public String getAdGroupName() {
        return this.adGroupName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupNegativeLocationCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupNegativeLocationCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeLocationCriterion, String>("Status", new Function<BulkAdGroupNegativeLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeLocationCriterion c) {
                AdGroupCriterionStatus status = c.getNegativeAdGroupCriterion().getStatus();
                return status == null ? null : status.value();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeLocationCriterion c) {
                c.getNegativeAdGroupCriterion().setStatus(StringExtensions.parseOptional(v, new Function<String, AdGroupCriterionStatus>(){

                    @Override
                    public AdGroupCriterionStatus apply(String s) {
                        return AdGroupCriterionStatus.fromValue(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeLocationCriterion, Long>("Id", new Function<BulkAdGroupNegativeLocationCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeLocationCriterion c) {
                return c.getNegativeAdGroupCriterion().getId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeLocationCriterion c) {
                c.getNegativeAdGroupCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeLocationCriterion, Long>("Parent Id", new Function<BulkAdGroupNegativeLocationCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeLocationCriterion c) {
                return c.getNegativeAdGroupCriterion().getAdGroupId();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeLocationCriterion c) {
                c.getNegativeAdGroupCriterion().setAdGroupId(Long.parseLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeLocationCriterion, String>("Campaign", new Function<BulkAdGroupNegativeLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeLocationCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeLocationCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeLocationCriterion, String>("Ad Group", new Function<BulkAdGroupNegativeLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeLocationCriterion c) {
                return c.getAdGroupName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeLocationCriterion c) {
                c.setAdGroupName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeLocationCriterion, String>("Target", new Function<BulkAdGroupNegativeLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeLocationCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    Long locationId = ((LocationCriterion)c.getNegativeAdGroupCriterion().getCriterion()).getLocationId();
                    return locationId == null ? null : locationId.toString();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupNegativeLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeLocationCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getNegativeAdGroupCriterion().getCriterion()).setLocationId(Long.parseLong(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeLocationCriterion, String>("Sub Type", new Function<BulkAdGroupNegativeLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeLocationCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    return ((LocationCriterion)c.getNegativeAdGroupCriterion().getCriterion()).getLocationType();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupNegativeLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeLocationCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getNegativeAdGroupCriterion().getCriterion()).setLocationType(v);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeLocationCriterion, String>("Name", new Function<BulkAdGroupNegativeLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeLocationCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    return ((LocationCriterion)c.getNegativeAdGroupCriterion().getCriterion()).getDisplayName();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupNegativeLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeLocationCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getNegativeAdGroupCriterion().getCriterion()).setDisplayName(v);
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

