/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v10.bulk.entities.BulkTargetBid;
import com.microsoft.bingads.v10.bulk.entities.BulkTargetIdentifier;
import com.microsoft.bingads.v10.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v10.campaignmanagement.DeviceOSTargetBid;
import com.microsoft.bingads.v10.internal.bulk.BulkMapping;
import com.microsoft.bingads.v10.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v10.internal.bulk.RowValues;
import com.microsoft.bingads.v10.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v10.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

abstract class BulkDeviceOsTargetBid
extends BulkTargetBid {
    private DeviceOSTargetBid deviceOsTargetBid;
    private static final List<BulkMapping<BulkDeviceOsTargetBid>> MAPPINGS;

    BulkDeviceOsTargetBid(BulkTargetIdentifier identifier) {
        super(identifier);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setDeviceOsTargetBid(new DeviceOSTargetBid());
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getDeviceOsTargetBid(), "DeviceOsTargetBid");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public DeviceOSTargetBid getDeviceOsTargetBid() {
        return this.deviceOsTargetBid;
    }

    public void setDeviceOsTargetBid(DeviceOSTargetBid deviceTargetBid) {
        this.deviceOsTargetBid = deviceTargetBid;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkDeviceOsTargetBid, Object>> m = new ArrayList<SimpleBulkMapping<BulkDeviceOsTargetBid, Object>>();
        m.add(new SimpleBulkMapping<BulkDeviceOsTargetBid, String>("Target", new Function<BulkDeviceOsTargetBid, String>(){

            @Override
            public String apply(BulkDeviceOsTargetBid c) {
                return c.getDeviceOsTargetBid().getDeviceName();
            }
        }, new BiConsumer<String, BulkDeviceOsTargetBid>(){

            @Override
            public void accept(String v, BulkDeviceOsTargetBid c) {
                c.getDeviceOsTargetBid().setDeviceName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkDeviceOsTargetBid, String>("OS Names", new Function<BulkDeviceOsTargetBid, String>(){

            @Override
            public String apply(BulkDeviceOsTargetBid c) {
                return c.getDeviceOsTargetBid().getOSNames() != null ? StringExtensions.join(";", c.getDeviceOsTargetBid().getOSNames().getStrings()) : null;
            }
        }, new BiConsumer<String, BulkDeviceOsTargetBid>(){

            @Override
            public void accept(String v, BulkDeviceOsTargetBid c) {
                if (!StringExtensions.isNullOrEmpty(v)) {
                    ArrayOfstring nameArray = new ArrayOfstring();
                    nameArray.getStrings().addAll(Arrays.asList(v.split(";")));
                    c.getDeviceOsTargetBid().setOSNames(nameArray);
                } else {
                    c.getDeviceOsTargetBid().setOSNames(null);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkDeviceOsTargetBid, Integer>("Bid Adjustment", new Function<BulkDeviceOsTargetBid, Integer>(){

            @Override
            public Integer apply(BulkDeviceOsTargetBid c) {
                return c.getDeviceOsTargetBid().getBidAdjustment();
            }
        }, new BiConsumer<String, BulkDeviceOsTargetBid>(){

            @Override
            public void accept(String v, BulkDeviceOsTargetBid c) {
                c.getDeviceOsTargetBid().setBidAdjustment(Integer.parseInt(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

