/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.reporting;

import com.microsoft.bingads.AsyncCallback;
import com.microsoft.bingads.ServiceClient;
import com.microsoft.bingads.internal.ParentCallback;
import com.microsoft.bingads.internal.ResultFuture;
import com.microsoft.bingads.reporting.IReportingService;
import com.microsoft.bingads.reporting.ReportingOperationStatus;
import com.microsoft.bingads.reporting.ReportingStatusProvider;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ReportingOperationTracker {
    private static final int INITIAL_STATUS_CHECK_INTERVAL_IN_MS = 1000;
    private static final int NUMBER_OF_INITIAL_STATUS_CHECKS = 5;
    private int numberOfStatusChecks = 0;
    private ScheduledExecutorService executorService;
    private ReportingStatusProvider statusProvider;
    private boolean stopTracking;
    protected int lastProgressReported;
    private ReportingOperationStatus currentStatus;
    private final int statusCheckIntervalInMs;
    private ResultFuture<ReportingOperationStatus> trackResultFuture;
    private ServiceClient<IReportingService> serviceClient;
    private final Runnable pollExecutorTask = new Runnable(){

        @Override
        public void run() {
            ReportingOperationTracker.this.pollOperationStatus();
        }
    };
    AtomicBoolean statusUpdateInProgress = new AtomicBoolean(false);

    public ReportingOperationTracker(ReportingStatusProvider statusProvider, ServiceClient<IReportingService> serviceClient, int statusCheckIntervalInMs) {
        this.statusCheckIntervalInMs = statusCheckIntervalInMs;
        this.statusProvider = statusProvider;
        this.serviceClient = serviceClient;
    }

    public void pollOperationStatus() {
        try {
            if (!this.statusUpdateInProgress.compareAndSet(false, true)) {
                return;
            }
            if (this.trackingWasStopped()) {
                return;
            }
            if (this.cancelPollingIfRequestedByUser()) {
                return;
            }
            this.refreshStatus(new AsyncCallback<ReportingOperationStatus>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCompleted(Future<ReportingOperationStatus> result) {
                    try {
                        result.get();
                        ReportingOperationTracker.this.numberOfStatusChecks++;
                        ReportingOperationTracker.this.completeTaskIfOperationIsComplete();
                    }
                    catch (InterruptedException ex) {
                        ReportingOperationTracker.this.stopTracking();
                        ReportingOperationTracker.this.propagateExceptionToCallingThread(ex);
                    }
                    catch (ExecutionException ex) {
                        ReportingOperationTracker.this.stopTracking();
                        ReportingOperationTracker.this.propagateExceptionToCallingThread(ex);
                    }
                    finally {
                        ReportingOperationTracker.this.statusUpdateInProgress.set(false);
                        if (!ReportingOperationTracker.this.stopTracking) {
                            int interval = 1000;
                            if (ReportingOperationTracker.this.numberOfStatusChecks >= 5) {
                                interval = ReportingOperationTracker.this.statusCheckIntervalInMs;
                            }
                            ReportingOperationTracker.this.executorService.schedule(ReportingOperationTracker.this.pollExecutorTask, (long)interval, TimeUnit.MILLISECONDS);
                        }
                    }
                }
            });
        }
        catch (Throwable ex) {
            this.stopTracking();
            this.propagateExceptionToCallingThread(ex);
        }
    }

    private boolean cancelPollingIfRequestedByUser() {
        if (this.trackResultFuture.isCancelled()) {
            this.stopTracking();
            return true;
        }
        return false;
    }

    private void propagateExceptionToCallingThread(Throwable ex) {
        this.trackResultFuture.setException(ex);
    }

    private void completeTaskIfOperationIsComplete() {
        if (this.operationIsComplete()) {
            this.stopTracking();
            this.completeTaskWithResult();
        }
    }

    private void completeTaskWithResult() {
        this.trackResultFuture.setResult(this.currentStatus);
    }

    private boolean operationIsComplete() {
        return this.statusProvider.isFinalStatus(this.currentStatus);
    }

    private void refreshStatus(AsyncCallback<ReportingOperationStatus> callback) {
        final ResultFuture<ReportingOperationStatus> resultFuture = new ResultFuture<ReportingOperationStatus>(callback);
        this.statusProvider.getCurrentStatus(this.serviceClient, (AsyncCallback<ReportingOperationStatus>)new ParentCallback<ReportingOperationStatus>(resultFuture){

            @Override
            public void onSuccess(ReportingOperationStatus result) {
                ReportingOperationTracker.this.currentStatus = result;
                resultFuture.setResult(ReportingOperationTracker.this.currentStatus);
            }
        });
    }

    private boolean trackingWasStopped() {
        return this.stopTracking;
    }

    private void stopTracking() {
        this.stopTracking = true;
        this.executorService.shutdown();
    }

    public Future<ReportingOperationStatus> trackResultFileAsync(AsyncCallback<ReportingOperationStatus> callback) {
        this.trackResultFuture = new ResultFuture<ReportingOperationStatus>(callback);
        this.startTracking();
        return this.trackResultFuture;
    }

    private void startTracking() {
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.executorService.schedule(this.pollExecutorTask, 1000L, TimeUnit.MILLISECONDS);
    }
}

