/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v10.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.Consumer;
import com.microsoft.bingads.v10.bulk.entities.BulkDeviceOsTargetBid;
import com.microsoft.bingads.v10.bulk.entities.BulkSubTarget;
import com.microsoft.bingads.v10.campaignmanagement.ArrayOfDeviceOSTargetBid;
import com.microsoft.bingads.v10.campaignmanagement.DeviceOSTarget;
import com.microsoft.bingads.v10.campaignmanagement.DeviceOSTargetBid;
import java.util.ArrayList;
import java.util.List;

abstract class BulkDeviceOsTarget<TBid extends BulkDeviceOsTargetBid>
extends BulkSubTarget<TBid> {
    private DeviceOSTarget deviceOSTarget;

    public BulkDeviceOsTarget(Class<TBid> classOfTBid) {
        super(classOfTBid);
    }

    @Override
    void reconstructSubTargets() {
        this.setDeviceOsTarget(new DeviceOSTarget());
        ArrayOfDeviceOSTargetBid bids = new ArrayOfDeviceOSTargetBid();
        this.getDeviceOsTarget().setBids(bids);
        for (BulkDeviceOsTargetBid bid : this.getBids()) {
            bids.getDeviceOSTargetBids().add(bid.getDeviceOsTargetBid());
        }
    }

    @Override
    List<TBid> convertApiToBulkBids() {
        ArrayList<BulkDeviceOsTargetBid> bulkBids = new ArrayList<BulkDeviceOsTargetBid>();
        if (this.getDeviceOsTarget() == null || this.getDeviceOsTarget().getBids() == null) {
            return bulkBids;
        }
        for (final DeviceOSTargetBid apiBid : this.getDeviceOsTarget().getBids().getDeviceOSTargetBids()) {
            BulkDeviceOsTargetBid bulkBid = (BulkDeviceOsTargetBid)this.createAndPopulateBid(new Consumer<TBid>(){

                @Override
                public void accept(TBid t) {
                    ((BulkDeviceOsTargetBid)t).setDeviceOsTargetBid(apiBid);
                }
            });
            bulkBids.add(bulkBid);
        }
        return bulkBids;
    }

    @Override
    void validatePropertiesNotNull() {
        this.validatePropertyNotNull(this.getDeviceOsTarget(), "DeviceOsTarget");
    }

    @Override
    void validateBidsNotNullOrEmpty() {
        if (this.getDeviceOsTarget() != null) {
            this.validateListNotNullOrEmpty(this.getDeviceOsTarget().getBids(), this.getDeviceOsTarget().getBids().getDeviceOSTargetBids(), "DeviceOsTarget.Bids");
        }
    }

    public DeviceOSTarget getDeviceOsTarget() {
        return this.deviceOSTarget;
    }

    public void setDeviceOsTarget(DeviceOSTarget ageTarget) {
        this.deviceOSTarget = ageTarget;
    }
}

