/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.reporting;

import com.microsoft.bingads.AsyncCallback;
import com.microsoft.bingads.AuthorizationData;
import com.microsoft.bingads.ServiceClient;
import com.microsoft.bingads.internal.ParentCallback;
import com.microsoft.bingads.internal.ResultFuture;
import com.microsoft.bingads.internal.utilities.HttpClientHttpFileService;
import com.microsoft.bingads.internal.utilities.HttpFileService;
import com.microsoft.bingads.internal.utilities.SimpleZipExtractor;
import com.microsoft.bingads.internal.utilities.ZipExtractor;
import com.microsoft.bingads.reporting.IReportingService;
import com.microsoft.bingads.reporting.ReportingOperationCouldNotBeCompletedException;
import com.microsoft.bingads.reporting.ReportingOperationInProgressException;
import com.microsoft.bingads.reporting.ReportingOperationStatus;
import com.microsoft.bingads.reporting.ReportingOperationTracker;
import com.microsoft.bingads.reporting.ReportingStatusProvider;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.Future;

public class ReportingDownloadOperation {
    private AuthorizationData authorizationData;
    private String requestId;
    private String trackingId;
    private int statusPollIntervalInMilliseconds;
    ReportingStatusProvider statusProvider;
    private HttpFileService httpFileService;
    private ZipExtractor zipExtractor;
    private ServiceClient<IReportingService> serviceClient;
    private ReportingOperationStatus finalStatus;

    public ReportingDownloadOperation(String requestId, AuthorizationData authorizationData) {
        this(requestId, authorizationData, null);
    }

    ReportingDownloadOperation(String requestId, AuthorizationData authorizationData, String trackingId) {
        this(requestId, authorizationData, new ReportingStatusProvider(requestId, authorizationData), trackingId);
    }

    ReportingDownloadOperation(String requestId, AuthorizationData authorizationData, ReportingStatusProvider statusProvider, String trackingId) {
        this.statusProvider = statusProvider;
        this.requestId = requestId;
        this.authorizationData = authorizationData;
        this.trackingId = trackingId;
        this.statusPollIntervalInMilliseconds = 5000;
        this.serviceClient = new ServiceClient<IReportingService>(authorizationData, IReportingService.class);
        this.zipExtractor = new SimpleZipExtractor();
        this.httpFileService = new HttpClientHttpFileService();
    }

    public Future<ReportingOperationStatus> trackAsync(AsyncCallback<ReportingOperationStatus> callback) {
        ReportingOperationTracker tracker = this.generateTracker();
        final ResultFuture<ReportingOperationStatus> resultFuture = new ResultFuture<ReportingOperationStatus>(callback);
        tracker.trackResultFileAsync((AsyncCallback<ReportingOperationStatus>)new ParentCallback<ReportingOperationStatus>(resultFuture){

            @Override
            public void onSuccess(ReportingOperationStatus status) {
                ReportingDownloadOperation.this.finalStatus = status;
                resultFuture.setResult(ReportingDownloadOperation.this.finalStatus);
            }
        });
        return resultFuture;
    }

    private ReportingOperationTracker generateTracker() {
        ReportingOperationTracker tracker = new ReportingOperationTracker(this.statusProvider, this.serviceClient, this.statusPollIntervalInMilliseconds);
        return tracker;
    }

    public Future<ReportingOperationStatus> getStatusAsync(AsyncCallback<ReportingOperationStatus> callback) {
        final ResultFuture<ReportingOperationStatus> resultFuture = new ResultFuture<ReportingOperationStatus>(callback);
        if (this.finalStatus != null) {
            resultFuture.setResult(this.finalStatus);
            return resultFuture;
        }
        this.statusProvider.getCurrentStatus(this.serviceClient, (AsyncCallback<ReportingOperationStatus>)new ParentCallback<ReportingOperationStatus>(resultFuture){

            @Override
            public void onSuccess(ReportingOperationStatus currentStatus) {
                if (ReportingDownloadOperation.this.statusProvider.isFinalStatus(currentStatus)) {
                    ReportingDownloadOperation.this.finalStatus = currentStatus;
                }
                resultFuture.setResult(currentStatus);
            }
        });
        return resultFuture;
    }

    public Future<File> downloadResultFileAsync(File localResultDirectoryName, String localResultFileName, boolean decompress, AsyncCallback<File> callback) throws IOException, URISyntaxException {
        return this.downloadResultFileAsync(localResultDirectoryName, localResultFileName, decompress, false, callback);
    }

    public Future<File> downloadResultFileAsync(File localResultDirectoryName, String localResultFileName, boolean decompress, boolean overwrite, AsyncCallback<File> callback) throws IOException, URISyntaxException {
        return this.downloadResultFileAsyncImpl(localResultDirectoryName, localResultFileName, decompress, overwrite, callback);
    }

    private Future<File> downloadResultFileAsyncImpl(final File localResultDirectoryName, final String localResultFileName, final boolean decompress, final boolean overwrite, AsyncCallback<File> callback) throws IOException, URISyntaxException {
        final ResultFuture<File> resultFuture = new ResultFuture<File>(callback);
        if (this.finalStatus == null) {
            this.getStatusAsync((AsyncCallback<ReportingOperationStatus>)new ParentCallback<ReportingOperationStatus>(resultFuture){

                @Override
                public void onSuccess(ReportingOperationStatus result) throws IOException, URISyntaxException {
                    if (ReportingDownloadOperation.this.finalStatus == null) {
                        resultFuture.setException(new ReportingOperationInProgressException());
                        return;
                    }
                    File resultFile = ReportingDownloadOperation.this.downloadFileWithFinalStatus(localResultDirectoryName, localResultFileName, decompress, overwrite);
                    resultFuture.setResult(resultFile);
                }
            });
        } else {
            File resultFile = this.downloadFileWithFinalStatus(localResultDirectoryName, localResultFileName, decompress, overwrite);
            resultFuture.setResult(resultFile);
        }
        return resultFuture;
    }

    private File downloadFileWithFinalStatus(File localResultDirectoryName, String localResultFileName, boolean decompress, boolean overwrite) throws IOException, URISyntaxException {
        if (!this.statusProvider.isSuccessStatus(this.finalStatus)) {
            throw new ReportingOperationCouldNotBeCompletedException(this.finalStatus.getStatus());
        }
        String effectiveFileName = localResultFileName == null ? this.requestId : localResultFileName;
        File fullPath = new File(localResultDirectoryName, effectiveFileName);
        File zipResultPath = new File(localResultDirectoryName, effectiveFileName + ".zip");
        this.downloadResultFileZip(this.finalStatus.getResultFileUrl(), zipResultPath, overwrite);
        if (!decompress) {
            return zipResultPath;
        }
        return this.zipExtractor.extractFirstEntryToFile(zipResultPath, fullPath, localResultFileName == null, overwrite);
    }

    private File downloadResultFileZip(String url, File tempZipFile, boolean overwrite) throws IOException, URISyntaxException {
        if (this.httpFileService == null) {
            this.httpFileService = new HttpClientHttpFileService();
        }
        this.httpFileService.downloadFile(url, tempZipFile, overwrite);
        return tempZipFile;
    }

    public AuthorizationData getAuthorizationData() {
        return this.authorizationData;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }

    public ReportingStatusProvider getStatusProvider() {
        return this.statusProvider;
    }

    public void setStatusProvider(ReportingStatusProvider statusProvider) {
        this.statusProvider = statusProvider;
    }

    public HttpFileService getHttpFileService() {
        return this.httpFileService;
    }

    public void setHttpFileService(HttpFileService httpFileService) {
        this.httpFileService = httpFileService;
    }

    public ZipExtractor getZipExtractor() {
        return this.zipExtractor;
    }

    public void setZipExtractor(ZipExtractor zipExtractor) {
        this.zipExtractor = zipExtractor;
    }

    public ServiceClient<IReportingService> getServiceClient() {
        return this.serviceClient;
    }

    public void setServiceClient(ServiceClient<IReportingService> serviceClient) {
        this.serviceClient = serviceClient;
    }

    public ReportingOperationStatus getFinalStatus() {
        return this.finalStatus;
    }

    public void setFinalStatus(ReportingOperationStatus finalStatus) {
        this.finalStatus = finalStatus;
    }

    public int getStatusPollIntervalInMilliseconds() {
        return this.statusPollIntervalInMilliseconds;
    }

    public void setStatusPollIntervalInMilliseconds(int statusPollIntervalInMilliseconds) {
        this.statusPollIntervalInMilliseconds = statusPollIntervalInMilliseconds;
    }
}

