/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.bulk.entities.BulkAdExtension;
import com.microsoft.bingads.campaignmanagement.ImageAdExtension;
import com.microsoft.bingads.internal.StringExtensions;
import com.microsoft.bingads.internal.bulk.BulkMapping;
import com.microsoft.bingads.internal.bulk.MappingHelpers;
import com.microsoft.bingads.internal.bulk.RowValues;
import com.microsoft.bingads.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkImageAdExtension
extends BulkAdExtension<ImageAdExtension> {
    private static final List<BulkMapping<BulkImageAdExtension>> MAPPINGS;

    public ImageAdExtension getImageAdExtension() {
        return (ImageAdExtension)this.getAdExtension();
    }

    public void setImageAdExtension(ImageAdExtension imageAdExtension) {
        this.setAdExtension(imageAdExtension);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        ImageAdExtension extension = new ImageAdExtension();
        extension.setType("ImageAdExtension");
        this.setAdExtension(extension);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getImageAdExtension(), "ImageAdExtension");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkImageAdExtension, Object>> m = new ArrayList<SimpleBulkMapping<BulkImageAdExtension, Object>>();
        m.add(new SimpleBulkMapping<BulkImageAdExtension, String>("Destination Url", new Function<BulkImageAdExtension, String>(){

            @Override
            public String apply(BulkImageAdExtension c) {
                return StringExtensions.toOptionalBulkString(c.getImageAdExtension().getDestinationUrl());
            }
        }, new BiConsumer<String, BulkImageAdExtension>(){

            @Override
            public void accept(String v, BulkImageAdExtension c) {
                c.getImageAdExtension().setDestinationUrl(StringExtensions.getValueOrEmptyString(v));
            }
        }, true));
        m.add(new SimpleBulkMapping<BulkImageAdExtension, String>("Alternative Text", new Function<BulkImageAdExtension, String>(){

            @Override
            public String apply(BulkImageAdExtension c) {
                return c.getImageAdExtension().getAlternativeText();
            }
        }, new BiConsumer<String, BulkImageAdExtension>(){

            @Override
            public void accept(String v, BulkImageAdExtension c) {
                c.getImageAdExtension().setAlternativeText(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkImageAdExtension, Long>("Media Id", new Function<BulkImageAdExtension, Long>(){

            @Override
            public Long apply(BulkImageAdExtension c) {
                return c.getImageAdExtension().getImageMediaId();
            }
        }, new BiConsumer<String, BulkImageAdExtension>(){

            @Override
            public void accept(String v, BulkImageAdExtension c) {
                c.getImageAdExtension().setImageMediaId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

