/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.AuthorizationData;
import com.microsoft.bingads.HeadersImpl;
import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.internal.OAuthWithAuthorizationCode;
import com.microsoft.bingads.internal.ServiceFactory;
import com.microsoft.bingads.internal.ServiceFactoryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.jws.WebService;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.jaxb.JAXBDataBinding;

public class ServiceClient<T> {
    private final AuthorizationData authorizationData;
    private final Class<T> serviceInterface;
    private final Service service;
    private final ServiceFactory serviceFactory;
    private ApiEnvironment environment;

    public ApiEnvironment getEnvironment() {
        return this.environment;
    }

    public AuthorizationData getAuthorizationData() {
        return this.authorizationData;
    }

    public ServiceClient(AuthorizationData authorizationData, Class<T> serviceInterface) {
        this(authorizationData, ApiEnvironment.PRODUCTION, serviceInterface);
        ApiEnvironment environmentFromConfig = super.getEnvironmentFromConfig();
        if (environmentFromConfig != null) {
            this.environment = environmentFromConfig;
        }
    }

    public ServiceClient(AuthorizationData authorizationData, ApiEnvironment environment, Class<T> serviceInterface) {
        this.authorizationData = authorizationData;
        this.serviceInterface = serviceInterface;
        this.environment = environment;
        this.serviceFactory = ServiceFactoryFactory.createServiceFactory();
        this.service = this.serviceFactory.createService(serviceInterface);
    }

    public T getService() {
        try {
            this.authorizationData.validate();
            T port = this.serviceFactory.createProxyFromService(this.service, this.environment, this.serviceInterface);
            WebService webServiceAnnotation = this.serviceInterface.getAnnotation(WebService.class);
            final String ns = webServiceAnnotation.targetNamespace();
            final ArrayList<Header> apacheHeaders = new ArrayList<Header>();
            if (this.authorizationData.getAccountId() != 0L) {
                apacheHeaders.add(new Header(new QName(ns, "CustomerAccountId"), (Object)Long.toString(this.authorizationData.getAccountId()), (DataBinding)new JAXBDataBinding(new Class[]{String.class})));
            }
            if (this.authorizationData.getCustomerId() != 0L) {
                apacheHeaders.add(new Header(new QName(ns, "CustomerId"), (Object)Long.toString(this.authorizationData.getCustomerId()), (DataBinding)new JAXBDataBinding(new Class[]{String.class})));
            }
            apacheHeaders.add(new Header(new QName(ns, "DeveloperToken"), (Object)this.authorizationData.getDeveloperToken(), (DataBinding)new JAXBDataBinding(new Class[]{String.class})));
            this.refreshOAuthTokensIfNeeded();
            this.authorizationData.getAuthentication().addHeaders(new HeadersImpl(){

                @Override
                public void addHeader(String name, String value) {
                    try {
                        apacheHeaders.add(new Header(new QName(ns, name), (Object)value, (DataBinding)new JAXBDataBinding(new Class[]{String.class})));
                    }
                    catch (JAXBException ex) {
                        throw new InternalException(ex);
                    }
                }
            });
            ((BindingProvider)port).getRequestContext().put(Header.HEADER_LIST, apacheHeaders);
            return port;
        }
        catch (JAXBException ex) {
            throw new InternalException(ex);
        }
    }

    private void refreshOAuthTokensIfNeeded() {
        if (this.authorizationData.getAuthentication() instanceof OAuthWithAuthorizationCode) {
            OAuthWithAuthorizationCode auth = (OAuthWithAuthorizationCode)this.authorizationData.getAuthentication();
            auth.refreshTokensIfNeeded(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiEnvironment getEnvironmentFromConfig() {
        InputStream input = null;
        try {
            input = this.getClass().getClassLoader().getResourceAsStream("bingads.properties");
            if (input == null) {
                ApiEnvironment apiEnvironment = null;
                return apiEnvironment;
            }
            Properties props = new Properties();
            props.load(input);
            String envString = props.getProperty("environment");
            if (envString == null) {
                ApiEnvironment apiEnvironment = null;
                return apiEnvironment;
            }
            ApiEnvironment apiEnvironment = ApiEnvironment.fromValue(envString);
            return apiEnvironment;
        }
        catch (IOException ex) {
            ApiEnvironment apiEnvironment = null;
            return apiEnvironment;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                throw new InternalException(ex);
            }
        }
    }
}

