/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.repository.support;

import com.azure.data.cosmos.CosmosContainerResponse;
import com.azure.data.cosmos.PartitionKey;
import com.microsoft.azure.spring.data.cosmosdb.core.ReactiveCosmosOperations;
import com.microsoft.azure.spring.data.cosmosdb.core.query.Criteria;
import com.microsoft.azure.spring.data.cosmosdb.core.query.CriteriaType;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentQuery;
import com.microsoft.azure.spring.data.cosmosdb.repository.ReactiveCosmosRepository;
import com.microsoft.azure.spring.data.cosmosdb.repository.support.CosmosEntityInformation;
import java.io.Serializable;
import org.reactivestreams.Publisher;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleReactiveCosmosRepository<T, K extends Serializable>
implements ReactiveCosmosRepository<T, K> {
    private final CosmosEntityInformation<T, K> entityInformation;
    private final ReactiveCosmosOperations cosmosOperations;

    public SimpleReactiveCosmosRepository(CosmosEntityInformation<T, K> metadata, ApplicationContext applicationContext) {
        this.cosmosOperations = (ReactiveCosmosOperations)applicationContext.getBean(ReactiveCosmosOperations.class);
        this.entityInformation = metadata;
        this.createCollectionIfNotExists();
    }

    public SimpleReactiveCosmosRepository(CosmosEntityInformation<T, K> metadata, ReactiveCosmosOperations reactiveCosmosOperations) {
        this.cosmosOperations = reactiveCosmosOperations;
        this.entityInformation = metadata;
        this.createCollectionIfNotExists();
    }

    private CosmosContainerResponse createCollectionIfNotExists() {
        return (CosmosContainerResponse)this.cosmosOperations.createCollectionIfNotExists(this.entityInformation).block();
    }

    public Flux<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL)).with(sort);
        return this.cosmosOperations.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    public <S extends T> Mono<S> save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        if (this.entityInformation.isNew(entity)) {
            return this.cosmosOperations.insert(this.entityInformation.getCollectionName(), entity, this.createKey(this.entityInformation.getPartitionKeyFieldValue(entity)));
        }
        return this.cosmosOperations.upsert(this.entityInformation.getCollectionName(), entity, this.createKey(this.entityInformation.getPartitionKeyFieldValue(entity)));
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        return Flux.fromIterable(entities).flatMap(this::save);
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        Assert.notNull(entityStream, (String)"The given Publisher of entities must not be null!");
        return Flux.from(entityStream).flatMap(this::save);
    }

    public Mono<T> findById(K id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.cosmosOperations.findById(this.entityInformation.getCollectionName(), id, this.entityInformation.getJavaType());
    }

    public Mono<T> findById(Publisher<K> publisher) {
        Assert.notNull(publisher, (String)"The given id must not be null!");
        return Mono.from(publisher).flatMap(id -> this.cosmosOperations.findById(this.entityInformation.getCollectionName(), id, this.entityInformation.getJavaType()));
    }

    @Override
    public Mono<T> findById(K id, PartitionKey partitionKey) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.cosmosOperations.findById(id, this.entityInformation.getJavaType(), partitionKey);
    }

    public Mono<Boolean> existsById(K id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.cosmosOperations.existsById(id, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    public Mono<Boolean> existsById(Publisher<K> publisher) {
        Assert.notNull(publisher, (String)"The given id must not be null!");
        return Mono.from(publisher).flatMap(id -> this.cosmosOperations.existsById(id, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()));
    }

    public Flux<T> findAll() {
        return this.cosmosOperations.findAll(this.entityInformation.getCollectionName(), this.entityInformation.getJavaType());
    }

    public Flux<T> findAllById(Iterable<K> ids) {
        Assert.notNull(ids, (String)"Iterable ids should not be null");
        throw new UnsupportedOperationException();
    }

    public Flux<T> findAllById(Publisher<K> ids) {
        Assert.notNull(ids, (String)"The given Publisher of Id's must not be null!");
        throw new UnsupportedOperationException();
    }

    public Mono<Long> count() {
        return this.cosmosOperations.count(this.entityInformation.getCollectionName());
    }

    public Mono<Void> deleteById(K id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.cosmosOperations.deleteById(this.entityInformation.getCollectionName(), id, null);
    }

    public Mono<Void> deleteById(Publisher<K> publisher) {
        Assert.notNull(publisher, (String)"Id must not be null!");
        return Mono.from(publisher).flatMap(id -> this.cosmosOperations.deleteById(this.entityInformation.getCollectionName(), id, null)).then();
    }

    @Override
    public Mono<Void> deleteById(K id, PartitionKey partitionKey) {
        Assert.notNull(id, (String)"Id must not be null!");
        Assert.notNull((Object)partitionKey, (String)"PartitionKey must not be null!");
        return this.cosmosOperations.deleteById(this.entityInformation.getCollectionName(), id, partitionKey);
    }

    public Mono<Void> delete(@NonNull T entity) {
        Assert.notNull(entity, (String)"entity to be deleted must not be null!");
        K id = this.entityInformation.getId(entity);
        return this.cosmosOperations.deleteById(this.entityInformation.getCollectionName(), id, this.createKey(this.entityInformation.getPartitionKeyFieldValue(entity)));
    }

    public Mono<Void> deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        return Flux.fromIterable(entities).flatMap(this::delete).then();
    }

    public Mono<Void> deleteAll(Publisher<? extends T> entityStream) {
        Assert.notNull(entityStream, (String)"The given Publisher of entities must not be null!");
        return Flux.from(entityStream).map(arg_0 -> this.entityInformation.getRequiredId(arg_0)).flatMap(this::deleteById).then();
    }

    public Mono<Void> deleteAll() {
        return this.cosmosOperations.deleteAll(this.entityInformation.getCollectionName(), this.entityInformation.getPartitionKeyFieldName());
    }

    private PartitionKey createKey(String partitionKeyValue) {
        if (StringUtils.isEmpty((Object)partitionKeyValue)) {
            return null;
        }
        return new PartitionKey((Object)partitionKeyValue);
    }
}

