/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.repository.support;

import com.azure.data.cosmos.CosmosContainerProperties;
import com.azure.data.cosmos.PartitionKey;
import com.microsoft.azure.spring.data.cosmosdb.core.CosmosOperations;
import com.microsoft.azure.spring.data.cosmosdb.core.query.Criteria;
import com.microsoft.azure.spring.data.cosmosdb.core.query.CriteriaType;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentQuery;
import com.microsoft.azure.spring.data.cosmosdb.repository.CosmosRepository;
import com.microsoft.azure.spring.data.cosmosdb.repository.support.CosmosEntityInformation;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SimpleCosmosRepository<T, ID extends Serializable>
implements CosmosRepository<T, ID> {
    private final CosmosOperations operation;
    private final CosmosEntityInformation<T, ID> information;

    public SimpleCosmosRepository(CosmosEntityInformation<T, ID> metadata, ApplicationContext applicationContext) {
        this.operation = (CosmosOperations)applicationContext.getBean(CosmosOperations.class);
        this.information = metadata;
        this.createCollectionIfNotExists();
    }

    public SimpleCosmosRepository(CosmosEntityInformation<T, ID> metadata, CosmosOperations dbOperations) {
        this.operation = dbOperations;
        this.information = metadata;
        this.createCollectionIfNotExists();
    }

    private CosmosContainerProperties createCollectionIfNotExists() {
        return this.operation.createCollectionIfNotExists(this.information);
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"entity must not be null");
        if (this.information.isNew(entity)) {
            return this.operation.insert(this.information.getCollectionName(), entity, this.createKey(this.information.getPartitionKeyFieldValue(entity)));
        }
        this.operation.upsert(this.information.getCollectionName(), entity, this.createKey(this.information.getPartitionKeyFieldValue(entity)));
        return entity;
    }

    private PartitionKey createKey(String partitionKeyValue) {
        if (StringUtils.isEmpty((Object)partitionKeyValue)) {
            return PartitionKey.None;
        }
        return new PartitionKey((Object)partitionKeyValue);
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"Iterable entities should not be null");
        entities.forEach(this::save);
        return entities;
    }

    public Iterable<T> findAll() {
        return this.operation.findAll(this.information.getCollectionName(), this.information.getJavaType());
    }

    public List<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"Iterable ids should not be null");
        return this.operation.findByIds(ids, this.information.getJavaType(), this.information.getCollectionName());
    }

    public Optional<T> findById(ID id) {
        Assert.notNull(id, (String)"id must not be null");
        if (id instanceof String && !StringUtils.hasText((String)((String)id))) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.operation.findById(this.information.getCollectionName(), id, this.information.getJavaType()));
    }

    @Override
    public Optional<T> findById(ID id, PartitionKey partitionKey) {
        Assert.notNull(id, (String)"id must not be null");
        if (id instanceof String && !StringUtils.hasText((String)((String)id))) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.operation.findById(id, this.information.getJavaType(), partitionKey));
    }

    public long count() {
        return this.operation.count(this.information.getCollectionName());
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"id to be deleted should not be null");
        this.operation.deleteById(this.information.getCollectionName(), id, null);
    }

    @Override
    public void deleteById(ID id, PartitionKey partitionKey) {
        Assert.notNull(id, (String)"id to be deleted should not be null");
        Assert.notNull((Object)partitionKey, (String)"partitionKey to be deleted should not be null");
        this.operation.deleteById(this.information.getCollectionName(), id, partitionKey);
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"entity to be deleted should not be null");
        String partitionKeyValue = this.information.getPartitionKeyFieldValue(entity);
        this.operation.deleteById(this.information.getCollectionName(), this.information.getId(entity), partitionKeyValue == null ? null : new PartitionKey((Object)partitionKeyValue));
    }

    public void deleteAll() {
        this.operation.deleteAll(this.information.getCollectionName(), this.information.getJavaType());
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Iterable entities should not be null");
        StreamSupport.stream(entities.spliterator(), true).forEach(this::delete);
    }

    public boolean existsById(ID primaryKey) {
        Assert.notNull(primaryKey, (String)"primaryKey should not be null");
        return this.findById(primaryKey).isPresent();
    }

    public Iterable<T> findAll(@NonNull Sort sort) {
        Assert.notNull((Object)sort, (String)"sort of findAll should not be null");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL)).with(sort);
        return this.operation.find(query, this.information.getJavaType(), this.information.getCollectionName());
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"pageable should not be null");
        return this.operation.findAll(pageable, this.information.getJavaType(), this.information.getCollectionName());
    }
}

