/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.repository.support;

import com.azure.data.cosmos.ExcludedPath;
import com.azure.data.cosmos.IncludedPath;
import com.azure.data.cosmos.IndexingMode;
import com.azure.data.cosmos.IndexingPolicy;
import com.microsoft.azure.spring.data.cosmosdb.Constants;
import com.microsoft.azure.spring.data.cosmosdb.common.ExpressionResolver;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.Document;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.DocumentIndexingPolicy;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.PartitionKey;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.json.JSONObject;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Version;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;

public class CosmosEntityInformation<T, ID>
extends AbstractEntityInformation<T, ID> {
    private static final String ETAG = "_etag";
    private Field id;
    private Field partitionKeyField;
    private String collectionName;
    private Integer requestUnit;
    private Integer timeToLive;
    private IndexingPolicy indexingPolicy;
    private boolean isVersioned;

    public CosmosEntityInformation(Class<T> domainClass) {
        super(domainClass);
        this.id = this.getIdField(domainClass);
        ReflectionUtils.makeAccessible((Field)this.id);
        this.collectionName = this.getCollectionName(domainClass);
        this.partitionKeyField = this.getPartitionKeyField(domainClass);
        if (this.partitionKeyField != null) {
            ReflectionUtils.makeAccessible((Field)this.partitionKeyField);
        }
        this.requestUnit = this.getRequestUnit(domainClass);
        this.timeToLive = this.getTimeToLive(domainClass);
        this.indexingPolicy = this.getIndexingPolicy(domainClass);
        this.isVersioned = this.getIsVersioned(domainClass);
    }

    public ID getId(T entity) {
        return (ID)ReflectionUtils.getField((Field)this.id, entity);
    }

    public Field getIdField() {
        return this.id;
    }

    public Class<ID> getIdType() {
        return this.id.getType();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Integer getRequestUnit() {
        return this.requestUnit;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    @NonNull
    public IndexingPolicy getIndexingPolicy() {
        return this.indexingPolicy;
    }

    public boolean isVersioned() {
        return this.isVersioned;
    }

    public String getPartitionKeyFieldName() {
        if (this.partitionKeyField == null) {
            return null;
        }
        PartitionKey partitionKey = this.partitionKeyField.getAnnotation(PartitionKey.class);
        return partitionKey.value().equals("") ? this.partitionKeyField.getName() : partitionKey.value();
    }

    public String getPartitionKeyFieldValue(T entity) {
        return this.partitionKeyField == null ? null : (String)ReflectionUtils.getField((Field)this.partitionKeyField, entity);
    }

    private IndexingPolicy getIndexingPolicy(Class<?> domainClass) {
        IndexingPolicy policy = new IndexingPolicy();
        policy.automatic(this.getIndexingPolicyAutomatic(domainClass).booleanValue());
        policy.indexingMode(this.getIndexingPolicyMode(domainClass));
        policy.setIncludedPaths(this.getIndexingPolicyIncludePaths(domainClass));
        policy.excludedPaths(this.getIndexingPolicyExcludePaths(domainClass));
        return policy;
    }

    private Field getIdField(Class<?> domainClass) {
        Field idField;
        List fields = FieldUtils.getFieldsListWithAnnotation(domainClass, Id.class);
        if (fields.isEmpty()) {
            idField = ReflectionUtils.findField((Class)this.getJavaType(), (String)"id");
        } else if (fields.size() == 1) {
            idField = (Field)fields.get(0);
        } else {
            throw new IllegalArgumentException("only one field with @Id annotation!");
        }
        if (idField == null) {
            throw new IllegalArgumentException("domain should contain @Id field or field named id");
        }
        if (idField.getType() != String.class && idField.getType() != Integer.class && idField.getType() != Integer.TYPE) {
            throw new IllegalArgumentException("type of id field must be String or Integer");
        }
        return idField;
    }

    private String getCollectionName(Class<?> domainClass) {
        String customCollectionName = domainClass.getSimpleName();
        Document annotation = domainClass.getAnnotation(Document.class);
        if (annotation != null && annotation.collection() != null && !annotation.collection().isEmpty()) {
            customCollectionName = ExpressionResolver.resolveExpression(annotation.collection());
        }
        return customCollectionName;
    }

    private Field getPartitionKeyField(Class<?> domainClass) {
        Field partitionKey = null;
        List fields = FieldUtils.getFieldsListWithAnnotation(domainClass, PartitionKey.class);
        if (fields.size() == 1) {
            partitionKey = (Field)fields.get(0);
        } else if (fields.size() > 1) {
            throw new IllegalArgumentException("Azure Cosmos DB supports only one partition key, only one field with @PartitionKey annotation!");
        }
        if (partitionKey != null && partitionKey.getType() != String.class) {
            throw new IllegalArgumentException("type of PartitionKey field must be String");
        }
        return partitionKey;
    }

    private Integer getRequestUnit(Class<?> domainClass) {
        Integer ru = Integer.parseInt("4000");
        Document annotation = domainClass.getAnnotation(Document.class);
        if (annotation != null && annotation.ru() != null && !annotation.ru().isEmpty()) {
            ru = Integer.parseInt(annotation.ru());
        }
        return ru;
    }

    private Integer getTimeToLive(Class<T> domainClass) {
        Integer ttl = -1;
        Document annotation = domainClass.getAnnotation(Document.class);
        if (annotation != null) {
            ttl = annotation.timeToLive();
        }
        return ttl;
    }

    private Boolean getIndexingPolicyAutomatic(Class<?> domainClass) {
        Boolean isAutomatic = true;
        DocumentIndexingPolicy annotation = domainClass.getAnnotation(DocumentIndexingPolicy.class);
        if (annotation != null) {
            isAutomatic = annotation.automatic();
        }
        return isAutomatic;
    }

    private IndexingMode getIndexingPolicyMode(Class<?> domainClass) {
        IndexingMode mode = Constants.DEFAULT_INDEXINGPOLICY_MODE;
        DocumentIndexingPolicy annotation = domainClass.getAnnotation(DocumentIndexingPolicy.class);
        if (annotation != null) {
            mode = annotation.mode();
        }
        return mode;
    }

    private List<IncludedPath> getIndexingPolicyIncludePaths(Class<?> domainClass) {
        String[] rawPaths;
        ArrayList<IncludedPath> pathArrayList = new ArrayList<IncludedPath>();
        DocumentIndexingPolicy annotation = domainClass.getAnnotation(DocumentIndexingPolicy.class);
        if (annotation == null || annotation.includePaths() == null || annotation.includePaths().length == 0) {
            return null;
        }
        for (String path : rawPaths = annotation.includePaths()) {
            pathArrayList.add(new IncludedPath(path));
        }
        return pathArrayList;
    }

    private List<ExcludedPath> getIndexingPolicyExcludePaths(Class<?> domainClass) {
        String[] rawPaths;
        ArrayList<ExcludedPath> pathArrayList = new ArrayList<ExcludedPath>();
        DocumentIndexingPolicy annotation = domainClass.getAnnotation(DocumentIndexingPolicy.class);
        if (annotation == null || annotation.excludePaths().length == 0) {
            return null;
        }
        for (String path : rawPaths = annotation.excludePaths()) {
            JSONObject obj = new JSONObject(path);
            pathArrayList.add(new ExcludedPath().path(obj.get("path").toString()));
        }
        return pathArrayList;
    }

    private boolean getIsVersioned(Class<T> domainClass) {
        Field findField = ReflectionUtils.findField(domainClass, (String)ETAG);
        return findField != null && findField.getType() == String.class && findField.isAnnotationPresent(Version.class);
    }
}

