/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.core.query;

import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

public class CosmosPageRequest
extends PageRequest {
    private static final long serialVersionUID = 6093304300037688375L;
    private String requestContinuation;

    public CosmosPageRequest(int page, int size, String requestContinuation) {
        super(page, size, Sort.unsorted());
        this.requestContinuation = requestContinuation;
    }

    public static CosmosPageRequest of(int page, int size, String requestContinuation) {
        return new CosmosPageRequest(page, size, requestContinuation);
    }

    public CosmosPageRequest(int page, int size, String requestContinuation, Sort sort) {
        super(page, size, sort);
        this.requestContinuation = requestContinuation;
    }

    public static CosmosPageRequest of(int page, int size, String requestContinuation, Sort sort) {
        return new CosmosPageRequest(page, size, requestContinuation, sort);
    }

    public String getRequestContinuation() {
        return this.requestContinuation;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.requestContinuation != null ? this.requestContinuation.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CosmosPageRequest)) {
            return false;
        }
        CosmosPageRequest that = (CosmosPageRequest)((Object)obj);
        boolean continuationTokenEquals = this.requestContinuation != null ? this.requestContinuation.equals(that.requestContinuation) : that.requestContinuation == null;
        return continuationTokenEquals && super.equals((Object)that);
    }
}

