/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.core.convert;

import com.azure.data.cosmos.CosmosItemProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.spring.data.cosmosdb.core.convert.ObjectMapperFactory;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.CosmosPersistentEntity;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.CosmosPersistentProperty;
import com.microsoft.azure.spring.data.cosmosdb.exception.CosmosDBAccessException;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.EntityConverter;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.util.Assert;

public class MappingCosmosConverter
implements EntityConverter<CosmosPersistentEntity<?>, CosmosPersistentProperty, Object, CosmosItemProperties>,
ApplicationContextAware {
    protected final MappingContext<? extends CosmosPersistentEntity<?>, CosmosPersistentProperty> mappingContext;
    protected GenericConversionService conversionService;
    private ApplicationContext applicationContext;
    private ObjectMapper objectMapper;

    public MappingCosmosConverter(MappingContext<? extends CosmosPersistentEntity<?>, CosmosPersistentProperty> mappingContext, @Qualifier(value="cosmosdbObjectMapper") ObjectMapper objectMapper) {
        this.mappingContext = mappingContext;
        this.conversionService = new GenericConversionService();
        this.objectMapper = objectMapper == null ? ObjectMapperFactory.getObjectMapper() : objectMapper;
    }

    public <R> R read(Class<R> type, CosmosItemProperties cosmosItemProperties) {
        if (cosmosItemProperties == null) {
            return null;
        }
        CosmosPersistentEntity entity = (CosmosPersistentEntity)this.mappingContext.getPersistentEntity(type);
        Assert.notNull((Object)entity, (String)"Entity is null.");
        return this.readInternal(entity, type, cosmosItemProperties);
    }

    private <R> R readInternal(CosmosPersistentEntity<?> entity, Class<R> type, CosmosItemProperties cosmosItemProperties) {
        try {
            CosmosPersistentProperty idProperty = (CosmosPersistentProperty)entity.getIdProperty();
            String idValue = cosmosItemProperties.id();
            JSONObject jsonObject = new JSONObject(cosmosItemProperties.toJson());
            if (idProperty != null) {
                jsonObject.remove("id");
                jsonObject.put(idProperty.getName(), (Object)idValue);
            }
            return (R)this.objectMapper.readValue(jsonObject.toString(), type);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read the source document " + cosmosItemProperties.toJson() + "  to target type " + type, e);
        }
    }

    @Deprecated
    public void write(Object sourceEntity, CosmosItemProperties document) {
        throw new UnsupportedOperationException("The feature is not implemented yet");
    }

    public CosmosItemProperties writeCosmosItemProperties(Object sourceEntity) {
        CosmosItemProperties cosmosItemProperties;
        if (sourceEntity == null) {
            return null;
        }
        CosmosPersistentEntity persistentEntity = (CosmosPersistentEntity)this.mappingContext.getPersistentEntity(sourceEntity.getClass());
        if (persistentEntity == null) {
            throw new MappingException("no mapping metadata for entity type: " + sourceEntity.getClass().getName());
        }
        ConvertingPropertyAccessor accessor = this.getPropertyAccessor(sourceEntity);
        CosmosPersistentProperty idProperty = (CosmosPersistentProperty)persistentEntity.getIdProperty();
        try {
            cosmosItemProperties = new CosmosItemProperties(this.objectMapper.writeValueAsString(sourceEntity));
        }
        catch (JsonProcessingException e) {
            throw new CosmosDBAccessException("Failed to map document value.", e);
        }
        if (idProperty != null) {
            Object value = accessor.getProperty((PersistentProperty)idProperty);
            String id = value == null ? null : value.toString();
            cosmosItemProperties.id(id);
        }
        return cosmosItemProperties;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public MappingContext<? extends CosmosPersistentEntity<?>, CosmosPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    private ConvertingPropertyAccessor getPropertyAccessor(Object entity) {
        CosmosPersistentEntity entityInformation = (CosmosPersistentEntity)this.mappingContext.getPersistentEntity(entity.getClass());
        Assert.notNull((Object)entityInformation, (String)"EntityInformation should not be null.");
        PersistentPropertyAccessor accessor = entityInformation.getPropertyAccessor(entity);
        return new ConvertingPropertyAccessor(accessor, (ConversionService)this.conversionService);
    }

    public static Object toCosmosDbValue(Object fromPropertyValue) {
        if (fromPropertyValue == null) {
            return null;
        }
        if (fromPropertyValue instanceof Date) {
            fromPropertyValue = ((Date)fromPropertyValue).getTime();
        } else if (fromPropertyValue instanceof ZonedDateTime) {
            fromPropertyValue = ((ZonedDateTime)fromPropertyValue).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss:SSSXXX"));
        } else if (fromPropertyValue instanceof Enum) {
            fromPropertyValue = fromPropertyValue.toString();
        }
        return fromPropertyValue;
    }
}

