/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.spring.data.cosmosdb.common.MacAddress;
import com.microsoft.azure.spring.data.cosmosdb.common.PropertyLoader;
import com.microsoft.azure.spring.data.cosmosdb.common.TelemetryEventData;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class TelemetrySender {
    private static final Logger log = LoggerFactory.getLogger(TelemetrySender.class);
    private static final String PROPERTY_INSTALLATION_ID = "installationId";
    private static final String PROPERTY_VERSION = "version";
    private static final String PROPERTY_SERVICE_NAME = "serviceName";
    private static final String PROJECT_INFO = "spring-data-cosmosdb/" + PropertyLoader.getProjectVersion();
    private static final String TELEMETRY_TARGET_URL = "https://dc.services.visualstudio.com/v2/track";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final int RETRY_LIMIT = 3;

    private ResponseEntity<String> executeRequest(TelemetryEventData eventData) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", MimeTypeUtils.APPLICATION_JSON.toString());
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpEntity body = new HttpEntity((Object)MAPPER.writeValueAsString((Object)eventData), (MultiValueMap)headers);
            return restTemplate.exchange(TELEMETRY_TARGET_URL, HttpMethod.POST, body, String.class, new Object[0]);
        }
        catch (JsonProcessingException | HttpClientErrorException ignore) {
            log.warn("Failed to exchange telemetry request, {}.", (Object)ignore.getMessage());
            return null;
        }
    }

    private void sendTelemetryData(@NonNull TelemetryEventData eventData) {
        if (eventData == null) {
            throw new NullPointerException("eventData");
        }
        ResponseEntity<String> response = null;
        for (int i = 0; i < 3; ++i) {
            response = this.executeRequest(eventData);
            if (response == null || response.getStatusCode() != HttpStatus.OK) continue;
            return;
        }
        if (response != null && response.getStatusCode() != HttpStatus.OK) {
            log.warn("Failed to send telemetry data, response status code {}.", (Object)response.getStatusCode().toString());
        }
    }

    public void send(String name) {
        Assert.hasText((String)name, (String)"Event name should contain text.");
        this.sendTelemetryData(new TelemetryEventData(name, this.getProperties()));
    }

    private Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(PROPERTY_VERSION, PROJECT_INFO);
        properties.put(PROPERTY_SERVICE_NAME, "cosmosdb");
        properties.put(PROPERTY_INSTALLATION_ID, MacAddress.getHashMac());
        return properties;
    }
}

