/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.common;

import com.azure.data.cosmos.CosmosResponse;
import com.azure.data.cosmos.CosmosResponseDiagnostics;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.FeedResponseDiagnostics;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.spring.data.cosmosdb.core.ResponseDiagnostics;
import com.microsoft.azure.spring.data.cosmosdb.core.ResponseDiagnosticsProcessor;
import com.microsoft.azure.spring.data.cosmosdb.core.convert.ObjectMapperFactory;
import com.microsoft.azure.spring.data.cosmosdb.exception.ConfigurationException;
import java.io.IOException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosmosdbUtils {
    private static final Logger log = LoggerFactory.getLogger(CosmosdbUtils.class);

    public static <T> T getCopyFrom(@NonNull T instance) {
        if (instance == null) {
            throw new NullPointerException("instance");
        }
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        try {
            String s = mapper.writeValueAsString(instance);
            return (T)mapper.readValue(s, instance.getClass());
        }
        catch (IOException e) {
            throw new ConfigurationException("failed to get copy from " + instance.getClass().getName(), e);
        }
    }

    public static void fillAndProcessResponseDiagnostics(ResponseDiagnosticsProcessor responseDiagnosticsProcessor, CosmosResponse cosmosResponse, FeedResponse feedResponse) {
        if (responseDiagnosticsProcessor == null) {
            return;
        }
        CosmosResponseDiagnostics cosmosResponseDiagnostics = null;
        if (cosmosResponse != null) {
            cosmosResponseDiagnostics = cosmosResponse.cosmosResponseDiagnosticsString();
        }
        FeedResponseDiagnostics feedResponseDiagnostics = null;
        if (feedResponse != null) {
            feedResponseDiagnostics = feedResponse.feedResponseDiagnostics();
        }
        if (cosmosResponseDiagnostics == null && (feedResponseDiagnostics == null || feedResponseDiagnostics.toString().isEmpty())) {
            log.debug("Empty response diagnostics");
            return;
        }
        ResponseDiagnostics responseDiagnostics = new ResponseDiagnostics(cosmosResponseDiagnostics, feedResponseDiagnostics);
        responseDiagnosticsProcessor.processResponseDiagnostics(responseDiagnostics);
    }
}

