/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.security;

import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import com.microsoft.azure.sdk.iot.provisioning.security.exceptions.SecurityProviderException;
import java.io.IOException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.UUID;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public abstract class SecurityProviderX509
extends SecurityProvider {
    private static final String CERT_ALIAS = "IOTHUB_SECURITY_PROVIDER_CERT_ALIAS";

    public abstract String getClientCertificateCommonName();

    public abstract X509Certificate getClientCertificate();

    public abstract Key getClientPrivateKey();

    public abstract Collection<X509Certificate> getIntermediateCertificatesChain();

    @Override
    public String getRegistrationId() {
        return this.getClientCertificateCommonName();
    }

    @Override
    public SSLContext getSSLContext() throws SecurityProviderException {
        try {
            return this.generateSSLContext(this.getClientCertificate(), this.getClientPrivateKey(), this.getIntermediateCertificatesChain());
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new SecurityProviderException(e);
        }
    }

    private SSLContext generateSSLContext(X509Certificate leafCertificate, Key leafPrivateKey, Collection<X509Certificate> signerCertificates) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        if (leafCertificate == null || leafPrivateKey == null || signerCertificates == null) {
            throw new IllegalArgumentException("cert or private key cannot be null");
        }
        String password = UUID.randomUUID().toString();
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        int noOfCerts = signerCertificates.size() + 1;
        Certificate[] certs = new X509Certificate[noOfCerts];
        int i = 0;
        certs[i++] = leafCertificate;
        for (X509Certificate c : signerCertificates) {
            certs[i++] = c;
        }
        keyStore.setKeyEntry(CERT_ALIAS, leafPrivateKey, password.toCharArray(), certs);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password.toCharArray());
        sslContext.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
        return sslContext;
    }
}

