/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.security;

import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import com.microsoft.azure.sdk.iot.provisioning.security.exceptions.SecurityProviderException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SecurityProviderSymmetricKey
extends SecurityProvider {
    private static final String HMAC_SHA_256 = "HmacSHA256";
    private final byte[] primaryKey;
    private byte[] secondaryKey;
    private final String registrationId;

    public SecurityProviderSymmetricKey(byte[] symmetricKey, String registrationId) {
        if (symmetricKey == null) {
            throw new IllegalArgumentException("Symmetric key cannot be null");
        }
        if (registrationId == null || registrationId.isEmpty()) {
            throw new IllegalArgumentException("Registration ID cannot be null");
        }
        this.primaryKey = symmetricKey;
        this.registrationId = registrationId;
    }

    public SecurityProviderSymmetricKey(String primaryKey, String secondaryKey, String registrationId) {
        if (primaryKey == null || primaryKey.isEmpty() || secondaryKey == null || secondaryKey.isEmpty()) {
            throw new IllegalArgumentException("Symmetric key cannot be null");
        }
        if (registrationId == null || registrationId.isEmpty()) {
            throw new IllegalArgumentException("Registration ID cannot be null");
        }
        this.primaryKey = primaryKey.getBytes(StandardCharsets.UTF_8);
        this.secondaryKey = secondaryKey.getBytes(StandardCharsets.UTF_8);
        this.registrationId = registrationId;
    }

    public byte[] getSymmetricKey() {
        return this.primaryKey;
    }

    public byte[] getSecondaryKey() {
        return this.secondaryKey;
    }

    @Override
    public String getRegistrationId() throws SecurityProviderException {
        if (this.registrationId == null || this.registrationId.isEmpty()) {
            throw new SecurityProviderException("Registration is null or empty");
        }
        return this.registrationId;
    }

    public byte[] HMACSignData(byte[] signature, byte[] base64DecodedKey) throws SecurityProviderException {
        if (signature == null || signature.length == 0 || base64DecodedKey == null || base64DecodedKey.length == 0) {
            throw new SecurityProviderException("Signature or Key cannot be null or empty");
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(base64DecodedKey, HMAC_SHA_256);
            Mac hMacSha256 = Mac.getInstance(HMAC_SHA_256);
            hMacSha256.init(secretKey);
            return hMacSha256.doFinal(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SecurityProviderException(e);
        }
    }

    public static byte[] ComputeDerivedSymmetricKey(byte[] enrollmentGroupSymmetricKey, String deviceId) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] masterKeyBytes = Base64.getDecoder().decode(enrollmentGroupSymmetricKey);
        SecretKeySpec secretKey = new SecretKeySpec(masterKeyBytes, HMAC_SHA_256);
        Mac hMacSha256 = Mac.getInstance(HMAC_SHA_256);
        hMacSha256.init(secretKey);
        return Base64.getEncoder().encode(hMacSha256.doFinal(deviceId.getBytes(StandardCharsets.UTF_8)));
    }
}

