/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.security;

import com.microsoft.azure.sdk.iot.provisioning.security.exceptions.SecurityProviderException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;

public abstract class SecurityProvider {
    static final String SSL_CONTEXT_PROTOCOL = "TLSv1.2";

    public abstract String getRegistrationId() throws SecurityProviderException;

    public SSLContext getSSLContext() throws SecurityProviderException {
        try {
            SSLContext sslContext = SSLContext.getInstance(SSL_CONTEXT_PROTOCOL);
            sslContext.init(null, null, new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new SecurityProviderException("Failed to create the default SSLContext instance", e);
        }
    }
}

