/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.security;

import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import com.microsoft.azure.sdk.iot.provisioning.security.exceptions.SecurityProviderException;
import java.io.IOException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public abstract class SecurityProviderX509
extends SecurityProvider {
    private static final String ALIAS_CERT_ALIAS = "ALIAS_CERT";

    public abstract String getClientCertificateCommonName();

    public abstract X509Certificate getClientCertificate();

    public abstract Key getClientPrivateKey();

    public abstract Collection<X509Certificate> getIntermediateCertificatesChain();

    @Override
    public String getRegistrationId() throws SecurityProviderException {
        return this.getClientCertificateCommonName();
    }

    @Override
    public SSLContext getSSLContext() throws SecurityProviderException {
        try {
            return this.generateSSLContext(this.getClientCertificate(), this.getClientPrivateKey(), this.getIntermediateCertificatesChain());
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | CertificateException e) {
            throw new SecurityProviderException(e);
        }
    }

    private TrustManager getDefaultX509TrustManager(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException, SecurityProviderException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return trustManager;
        }
        throw new SecurityProviderException("Could not retrieve X509 trust manager");
    }

    private KeyManager getDefaultX509KeyManager(KeyStore keyStore, String password) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, SecurityProviderException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password.toCharArray());
        for (KeyManager keyManager : keyManagerFactory.getKeyManagers()) {
            if (!(keyManager instanceof X509KeyManager)) continue;
            return keyManager;
        }
        throw new SecurityProviderException("Could not retrieve X509 Key Manager");
    }

    private SSLContext generateSSLContext(X509Certificate leafCertificate, Key leafPrivateKey, Collection<X509Certificate> signerCertificates) throws NoSuchProviderException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException, SecurityProviderException {
        if (leafCertificate == null || leafPrivateKey == null || signerCertificates == null) {
            throw new IllegalArgumentException("cert or private key cannot be null");
        }
        String password = UUID.randomUUID().toString();
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        KeyStore keyStore = this.getKeyStoreWithTrustedCerts();
        if (keyStore == null) {
            throw new SecurityProviderException("Key store with trusted certs cannot be null");
        }
        int noOfCerts = signerCertificates.size() + 1;
        Certificate[] certs = new X509Certificate[noOfCerts];
        int i = 0;
        certs[i++] = leafCertificate;
        for (X509Certificate c : signerCertificates) {
            certs[i++] = c;
        }
        keyStore.setKeyEntry(ALIAS_CERT_ALIAS, leafPrivateKey, password.toCharArray(), certs);
        sslContext.init(new KeyManager[]{this.getDefaultX509KeyManager(keyStore, password)}, new TrustManager[]{this.getDefaultX509TrustManager(keyStore)}, new SecureRandom());
        return sslContext;
    }
}

