/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.security;

import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import com.microsoft.azure.sdk.iot.provisioning.security.exceptions.SecurityProviderException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.codec.binary.Base32;

public abstract class SecurityProviderTpm
extends SecurityProvider {
    private static final String SHA_256 = "SHA-256";
    private static final String EQUALS = "=";

    public abstract byte[] activateIdentityKey(byte[] var1) throws SecurityProviderException;

    public abstract byte[] getEndorsementKey() throws SecurityProviderException;

    public abstract byte[] getStorageRootKey() throws SecurityProviderException;

    public abstract byte[] signWithIdentity(byte[] var1) throws SecurityProviderException;

    @Override
    public String getRegistrationId() throws SecurityProviderException {
        try {
            byte[] enrollmentKey = this.getEndorsementKey();
            MessageDigest digest = MessageDigest.getInstance(SHA_256);
            byte[] hash = digest.digest(enrollmentKey);
            Base32 base32 = new Base32();
            byte[] base32Encoded = base32.encode(hash);
            String registrationId = new String(base32Encoded).toLowerCase();
            if (registrationId.contains(EQUALS)) {
                registrationId = registrationId.replace(EQUALS, "").toLowerCase();
            }
            return registrationId;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityProviderException(e);
        }
    }

    @Override
    public SSLContext getSSLContext() throws SecurityProviderException {
        try {
            return this.generateSSLContext();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new SecurityProviderException(e);
        }
    }

    private SSLContext generateSSLContext() throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        KeyStore keyStore = this.getKeyStoreWithTrustedCerts();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        sslContext.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
        return sslContext;
    }
}

