/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.security;

import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import com.microsoft.azure.sdk.iot.provisioning.security.exceptions.SecurityProviderException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SecurityProviderSymmetricKey
extends SecurityProvider {
    private static final String HMAC_SHA_256 = "HmacSHA256";
    private byte[] primaryKey;
    private byte[] secondaryKey;
    private String registrationId;

    public SecurityProviderSymmetricKey(byte[] symmetricKey, String registrationId) {
        if (symmetricKey == null) {
            throw new IllegalArgumentException("Symmetric key cannot be null");
        }
        if (registrationId == null || registrationId.isEmpty()) {
            throw new IllegalArgumentException("Registration ID cannot be null");
        }
        this.primaryKey = symmetricKey;
        this.registrationId = registrationId;
    }

    public SecurityProviderSymmetricKey(String primaryKey, String secondaryKey, String registrationId) {
        if (primaryKey == null || primaryKey.isEmpty() || secondaryKey == null || secondaryKey.isEmpty()) {
            throw new IllegalArgumentException("Symmetric key cannot be null");
        }
        if (registrationId == null || registrationId.isEmpty()) {
            throw new IllegalArgumentException("Registration ID cannot be null");
        }
        this.primaryKey = primaryKey.getBytes();
        this.secondaryKey = secondaryKey.getBytes();
        this.registrationId = registrationId;
    }

    public byte[] getSymmetricKey() {
        return this.primaryKey;
    }

    @Override
    public String getRegistrationId() throws SecurityProviderException {
        if (this.registrationId == null || this.registrationId.isEmpty()) {
            throw new SecurityProviderException("Registration is null or empty");
        }
        return this.registrationId;
    }

    @Override
    public SSLContext getSSLContext() throws SecurityProviderException {
        try {
            return this.generateSSLContext();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new SecurityProviderException(e);
        }
    }

    private SSLContext generateSSLContext() throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        KeyStore keyStore = this.getKeyStoreWithTrustedCerts();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        sslContext.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    public byte[] HMACSignData(byte[] signature, byte[] base64DecodedKey) throws SecurityProviderException {
        if (signature == null || signature.length == 0 || base64DecodedKey == null || base64DecodedKey.length == 0) {
            throw new SecurityProviderException("Signature or Key cannot be null or empty");
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(base64DecodedKey, HMAC_SHA_256);
            Mac hMacSha256 = Mac.getInstance(HMAC_SHA_256);
            hMacSha256.init(secretKey);
            return hMacSha256.doFinal(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SecurityProviderException(e);
        }
    }
}

