/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

class TopicParser {
    private final String[] topicTokens;
    private static final String QUESTION = "?";
    private static final String REQ_ID = "$rid=";
    private static final String VERSION = "$version=";

    public TopicParser(String topic) {
        if (topic == null || topic.length() == 0) {
            throw new IllegalArgumentException("Unexpected topic");
        }
        this.topicTokens = topic.split("/");
    }

    String getRequestId(int tokenIndexReqID) {
        String reqId = null;
        if (tokenIndexReqID <= 0 || tokenIndexReqID >= this.topicTokens.length) {
            throw new IllegalArgumentException("Invalid token Index for request id");
        }
        String token = this.topicTokens[tokenIndexReqID];
        if (token.contains(REQ_ID) && token.contains(QUESTION)) {
            int startIndex = token.indexOf(REQ_ID) + REQ_ID.length();
            int endIndex = token.length();
            if (token.contains(VERSION) && !token.contains("?$version=")) {
                endIndex = token.indexOf(VERSION) - 1;
            }
            reqId = token.substring(startIndex, endIndex);
        }
        return reqId;
    }

    String getMethodName(int tokenIndexMethod) {
        if (tokenIndexMethod <= 0 || tokenIndexMethod >= this.topicTokens.length) {
            throw new IllegalArgumentException("Invalid token Index for Method Name");
        }
        String token = this.topicTokens[tokenIndexMethod];
        if (token == null) {
            throw new IllegalArgumentException("method name could not be parsed");
        }
        String methodName = token;
        return methodName;
    }
}

