/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.exceptions.IotHubClientException;
import com.microsoft.azure.sdk.iot.device.exceptions.MultiplexingClientRegistrationException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubServiceException;
import com.microsoft.azure.sdk.iot.device.transport.MultiplexingDeviceUnauthorizedException;
import com.microsoft.azure.sdk.iot.device.transport.ProtocolException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpConnectionForcedException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpConnectionThrottledException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpInternalErrorException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpLinkMessageSizeExceededException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpUnauthorizedAccessException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.ProtonIOException;
import com.microsoft.azure.sdk.iot.device.transport.https.exceptions.InternalServerErrorException;
import com.microsoft.azure.sdk.iot.device.transport.https.exceptions.ServerBusyException;
import com.microsoft.azure.sdk.iot.device.transport.https.exceptions.ThrottledException;
import com.microsoft.azure.sdk.iot.device.transport.https.exceptions.UnauthorizedException;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.exceptions.MqttBadUsernameOrPasswordException;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.exceptions.MqttIdentifierRejectedException;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.exceptions.MqttServerUnavailableException;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.exceptions.MqttUnauthorizedException;

public class TransportException
extends Exception {
    protected boolean isRetryable = false;

    public TransportException() {
    }

    public TransportException(String message) {
        super(message);
    }

    public TransportException(String message, Throwable cause) {
        super(message, cause);
    }

    public TransportException(Throwable cause) {
        super(cause);
    }

    public boolean isRetryable() {
        return this.isRetryable;
    }

    public void setRetryable(boolean isRetryable) {
        this.isRetryable = isRetryable;
    }

    public IotHubClientException toIotHubClientException() {
        if (this instanceof MultiplexingDeviceUnauthorizedException) {
            MultiplexingClientRegistrationException newException = new MultiplexingClientRegistrationException("Failed to open the multiplexing connection", (Exception)this);
            newException.setRegistrationExceptionsMap(((MultiplexingDeviceUnauthorizedException)this).getRegistrationExceptions());
            return newException;
        }
        if (this instanceof UnauthorizedException || this instanceof AmqpUnauthorizedAccessException || this instanceof MqttUnauthorizedException || this instanceof MqttBadUsernameOrPasswordException || this instanceof MqttIdentifierRejectedException) {
            return new IotHubClientException(IotHubStatusCode.UNAUTHORIZED, "Failed to open the client due to an authentication error", this);
        }
        if (this instanceof ThrottledException || this instanceof AmqpConnectionThrottledException || this instanceof AmqpConnectionForcedException) {
            return new IotHubClientException(IotHubStatusCode.THROTTLED, "Failed to open the client due to a throttling error", this);
        }
        if (this instanceof ServerBusyException || this instanceof MqttServerUnavailableException) {
            return new IotHubClientException(IotHubStatusCode.SERVER_BUSY, "Failed to open the client due to the server being busy", this);
        }
        if (this instanceof AmqpInternalErrorException || this instanceof InternalServerErrorException) {
            return new IotHubClientException(IotHubStatusCode.INTERNAL_SERVER_ERROR, "Failed to open the client due to the service encountering an internal server error", this);
        }
        if (this instanceof AmqpLinkMessageSizeExceededException) {
            return new IotHubClientException(IotHubStatusCode.REQUEST_ENTITY_TOO_LARGE, "Failed to send the request because it exceeded the IoT Hub message size limit", this);
        }
        if (this instanceof IotHubServiceException) {
            return new IotHubClientException(((IotHubServiceException)this).getStatusCode(), "", this);
        }
        if (this instanceof ProtonIOException) {
            return new IotHubClientException(IotHubStatusCode.IO_ERROR, "Failed to open the client due to network issues. See inner exception for more details", this);
        }
        if (this instanceof ProtocolException) {
            return new IotHubClientException(IotHubStatusCode.IO_ERROR, "Failed to open the client due to network issues. See inner exception for more details", this);
        }
        return new IotHubClientException(IotHubStatusCode.ERROR, "Failed to open the client. See inner exception for more details", this);
    }
}

