/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.hsm;

import com.microsoft.azure.sdk.iot.device.auth.SignatureProvider;
import com.microsoft.azure.sdk.iot.device.hsm.HttpsHsmClient;
import com.microsoft.azure.sdk.iot.device.hsm.UnixDomainSocketChannel;
import com.microsoft.azure.sdk.iot.device.hsm.parser.SignRequest;
import com.microsoft.azure.sdk.iot.device.hsm.parser.SignResponse;
import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHsmSignatureProvider
implements SignatureProvider {
    private static final Logger log = LoggerFactory.getLogger(HttpHsmSignatureProvider.class);
    private static final String ENCODING_CHARSET = "UTF-8";
    private static final String MAC = "HmacSHA256";
    private static final String DEFAULT_KEY_ID = "primary";
    private final Mac defaultSignRequestAlgo = Mac.getInstance("HmacSHA256");
    private final String apiVersion;
    private final HttpsHsmClient httpClient;

    public HttpHsmSignatureProvider(String providerUri, String apiVersion, UnixDomainSocketChannel unixDomainSocketChannel) throws URISyntaxException, NoSuchAlgorithmException {
        if (providerUri == null || providerUri.isEmpty()) {
            throw new IllegalArgumentException("provider uri cannot be null or empty");
        }
        if (apiVersion == null || apiVersion.isEmpty()) {
            throw new IllegalArgumentException("apiVersion cannot be null or empty");
        }
        log.trace("Creating HttpHsmSignatureProvider with providerUri {}", (Object)providerUri);
        this.httpClient = new HttpsHsmClient(providerUri, unixDomainSocketChannel);
        this.apiVersion = apiVersion;
    }

    @Override
    public String sign(String keyName, String data, String generationId) throws TransportException, UnsupportedEncodingException {
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException("Data cannot be null or empty");
        }
        SignRequest signRequest = new SignRequest();
        signRequest.setAlgo(this.defaultSignRequestAlgo);
        signRequest.setData(data.getBytes(ENCODING_CHARSET));
        signRequest.setKeyId(DEFAULT_KEY_ID);
        SignResponse response = this.httpClient.sign(this.apiVersion, keyName, signRequest, generationId);
        return URLEncoder.encode(response.getDigest(), ENCODING_CHARSET);
    }
}

