/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import com.microsoft.azure.sdk.iot.device.auth.IotHubAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasToken;
import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.SSLContext;

public abstract class IotHubSasTokenAuthenticationProvider
extends IotHubAuthenticationProvider {
    protected long tokenValidSecs = 3600L;
    int timeBufferPercentage = 85;
    private static final long MILLISECONDS_PER_SECOND = 1000L;
    private static final long MINIMUM_EXPIRATION_TIME_OFFSET = 1L;
    static final String ENCODING_FORMAT_NAME = StandardCharsets.UTF_8.displayName();
    protected IotHubSasToken sasToken;

    public abstract boolean canRefreshToken();

    public abstract char[] getSasToken() throws IOException, TransportException;

    public IotHubSasTokenAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId) {
        super(hostname, gatewayHostname, deviceId, moduleId);
    }

    IotHubSasTokenAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId, SSLContext sslContext) {
        super(hostname, gatewayHostname, deviceId, moduleId, sslContext);
    }

    public IotHubSasTokenAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId, long tokenValidSecs, int timeBufferPercentage) {
        super(hostname, gatewayHostname, deviceId, moduleId);
        this.setTokenValidSecs(tokenValidSecs);
        if (timeBufferPercentage < 1 || timeBufferPercentage > 100) {
            throw new IllegalArgumentException("Time buffer percentage must be a percentage between 1 and 100");
        }
        this.timeBufferPercentage = timeBufferPercentage;
    }

    IotHubSasTokenAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId, long tokenValidSecs, int timeBufferPercentage, SSLContext sslContext) {
        super(hostname, gatewayHostname, deviceId, moduleId, sslContext);
        this.setTokenValidSecs(tokenValidSecs);
        if (timeBufferPercentage < 1 || timeBufferPercentage > 100) {
            throw new IllegalArgumentException("Time buffer percentage must be a percentage between 1 and 100");
        }
        this.timeBufferPercentage = timeBufferPercentage;
    }

    public void setTokenValidSecs(long tokenValidSecs) {
        if (tokenValidSecs < 1L) {
            throw new IllegalArgumentException("tokens must live for more than 1 second");
        }
        this.tokenValidSecs = tokenValidSecs;
    }

    public boolean isAuthenticationProviderRenewalNecessary() {
        return this.sasToken != null && this.sasToken.isExpired();
    }

    public boolean isSasTokenExpired() {
        return this.sasToken != null && this.sasToken.isExpired();
    }

    public boolean shouldRefreshToken(boolean proactivelyRenew) {
        if (this.sasToken.isExpired()) {
            return true;
        }
        if (proactivelyRenew) {
            long currentTimeSeconds;
            long expiryTimeSeconds = IotHubSasToken.getExpiryTimeFromToken(this.sasToken.toString());
            long tokenStartTime = expiryTimeSeconds - this.tokenValidSecs;
            long bufferExpiryTime = (long)(this.getMillisecondsBeforeProactiveRenewal() / 100) + tokenStartTime;
            return bufferExpiryTime < (currentTimeSeconds = System.currentTimeMillis() / 1000L);
        }
        return false;
    }

    public int getMillisecondsBeforeProactiveRenewal() {
        int tokenValidMilliseconds = (int)this.tokenValidSecs * 1000;
        double timeBufferMultiplier = (double)this.timeBufferPercentage / 100.0;
        return (int)((double)tokenValidMilliseconds * timeBufferMultiplier);
    }

    public long getTokenValidSecs() {
        return this.tokenValidSecs;
    }

    long getExpiryTimeInSeconds() {
        return System.currentTimeMillis() / 1000L + this.tokenValidSecs + 1L;
    }
}

