/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.ClientConfiguration;
import com.microsoft.azure.sdk.iot.device.ClientOptions;
import com.microsoft.azure.sdk.iot.device.InternalClient;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageSentCallback;
import com.microsoft.azure.sdk.iot.device.SasTokenProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSSLContext;
import com.microsoft.azure.sdk.iot.device.edge.DirectMethodRequest;
import com.microsoft.azure.sdk.iot.device.edge.DirectMethodResponse;
import com.microsoft.azure.sdk.iot.device.edge.HttpsHsmTrustBundleProvider;
import com.microsoft.azure.sdk.iot.device.exceptions.IotHubClientException;
import com.microsoft.azure.sdk.iot.device.hsm.HttpHsmSignatureProvider;
import com.microsoft.azure.sdk.iot.device.hsm.IotHubSasTokenHsmAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.hsm.UnixDomainSocketChannel;
import com.microsoft.azure.sdk.iot.device.transport.IotHubServiceException;
import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsTransportManager;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleClient
extends InternalClient {
    private static final Logger log = LoggerFactory.getLogger(ModuleClient.class);
    private static final String DEFAULT_API_VERSION = "2018-06-28";
    private static final int DEFAULT_SAS_TOKEN_TIME_TO_LIVE_SECONDS = 3600;
    private static final int DEFAULT_SAS_TOKEN_BUFFER_PERCENTAGE = 85;
    private static final String IotEdgedUriVariableName = "IOTEDGE_WORKLOADURI";
    private static final String IotHubHostnameVariableName = "IOTEDGE_IOTHUBHOSTNAME";
    private static final String GatewayHostnameVariableName = "IOTEDGE_GATEWAYHOSTNAME";
    private static final String DeviceIdVariableName = "IOTEDGE_DEVICEID";
    private static final String ModuleIdVariableName = "IOTEDGE_MODULEID";
    private static final String ModuleGenerationIdVariableName = "IOTEDGE_MODULEGENERATIONID";
    private static final String AuthSchemeVariableName = "IOTEDGE_AUTHSCHEME";
    private static final String SasTokenAuthScheme = "sasToken";
    private static final String EdgehubConnectionstringVariableName = "EdgeHubConnectionString";
    private static final String IothubConnectionstringVariableName = "IotHubConnectionString";
    private static final String EdgeCaCertificateFileVariableName = "EdgeModuleCACertificateFile";

    public ModuleClient(String connectionString, IotHubClientProtocol protocol) throws IllegalArgumentException, UnsupportedOperationException {
        super(new IotHubConnectionString(connectionString), protocol, null);
        ModuleClient.commonConstructorVerifications(protocol, this.config);
        ModuleClient.commonConstructorSetup();
    }

    public ModuleClient(String connectionString, IotHubClientProtocol protocol, ClientOptions clientOptions) throws IllegalArgumentException, UnsupportedOperationException {
        super(new IotHubConnectionString(connectionString), protocol, clientOptions);
        ModuleClient.commonConstructorVerifications(protocol, this.config);
        ModuleClient.commonConstructorSetup();
    }

    public ModuleClient(String hostName, String deviceId, String moduleId, SasTokenProvider sasTokenProvider, IotHubClientProtocol protocol) {
        this(hostName, deviceId, moduleId, sasTokenProvider, protocol, null);
    }

    public ModuleClient(String hostName, String deviceId, String moduleId, SasTokenProvider sasTokenProvider, IotHubClientProtocol protocol, ClientOptions clientOptions) {
        super(hostName, deviceId, moduleId, sasTokenProvider, protocol, clientOptions);
        ModuleClient.commonConstructorVerifications(protocol, this.getConfig());
        ModuleClient.commonConstructorSetup();
    }

    public static ModuleClient createFromEnvironment(UnixDomainSocketChannel unixDomainSocketChannel) throws IotHubClientException {
        return ModuleClient.createFromEnvironment(unixDomainSocketChannel, IotHubClientProtocol.AMQPS);
    }

    public static ModuleClient createFromEnvironment(UnixDomainSocketChannel unixDomainSocketChannel, IotHubClientProtocol protocol) throws IotHubClientException {
        return ModuleClient.createFromEnvironment(unixDomainSocketChannel, protocol, null);
    }

    public static ModuleClient createFromEnvironment(UnixDomainSocketChannel unixDomainSocketChannel, IotHubClientProtocol protocol, ClientOptions clientOptions) throws IotHubClientException {
        HttpHsmSignatureProvider signatureProvider;
        log.info("Creating module client from environment with protocol {}...", (Object)protocol);
        Map<String, String> envVariables = System.getenv();
        log.debug("Checking for an edgehub connection string...");
        String connectionString = envVariables.get(EdgehubConnectionstringVariableName);
        if (connectionString == null) {
            log.debug("No edgehub connection string was configured, checking for an IoT hub connection string...");
            connectionString = envVariables.get(IothubConnectionstringVariableName);
        }
        if (connectionString != null) {
            SSLContext sslContext;
            log.debug("Creating module client with the provided connection string");
            String alternativeDefaultTrustedCert = envVariables.get(EdgeCaCertificateFileVariableName);
            if (alternativeDefaultTrustedCert != null && !alternativeDefaultTrustedCert.isEmpty()) {
                log.debug("Configuring module client to use the configured alternative trusted certificate");
                try {
                    sslContext = IotHubSSLContext.getSSLContextFromFile(alternativeDefaultTrustedCert);
                }
                catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    throw new IotHubClientException(IotHubStatusCode.ERROR, "Failed to create an SSLContext instance from the provided trusted cert file path", e);
                }
            } else {
                sslContext = new IotHubSSLContext().getSSLContext();
            }
            if (clientOptions != null && clientOptions.getSslContext() == null) {
                clientOptions = clientOptions.toBuilder().sslContext(sslContext).build();
            } else if (clientOptions == null) {
                clientOptions = ClientOptions.builder().sslContext(sslContext).build();
            } else {
                log.debug("Ignoring trusted certs saved in {} environment variable because custom SSLContext was provided in client options.", (Object)EdgeCaCertificateFileVariableName);
            }
            return new ModuleClient(connectionString, protocol, clientOptions);
        }
        log.info("No connection string was configured for this module, so it will get its credentials from the edgelet");
        String edgedUri = envVariables.get(IotEdgedUriVariableName);
        String deviceId = envVariables.get(DeviceIdVariableName);
        String moduleId = envVariables.get(ModuleIdVariableName);
        String hostname = envVariables.get(IotHubHostnameVariableName);
        String authScheme = envVariables.get(AuthSchemeVariableName);
        String gatewayHostname = envVariables.get(GatewayHostnameVariableName);
        String generationId = envVariables.get(ModuleGenerationIdVariableName);
        if (edgedUri == null) {
            throw new IllegalStateException("Environment variable IOTEDGE_WORKLOADURI is required.");
        }
        if (deviceId == null) {
            throw new IllegalStateException("Environment variable IOTEDGE_DEVICEID is required.");
        }
        if (moduleId == null) {
            throw new IllegalStateException("Environment variable IOTEDGE_MODULEID is required.");
        }
        if (hostname == null) {
            throw new IllegalStateException("Environment variable IOTEDGE_IOTHUBHOSTNAME is required.");
        }
        if (authScheme == null) {
            throw new IllegalStateException("Environment variable IOTEDGE_AUTHSCHEME is required.");
        }
        if (generationId == null) {
            throw new IllegalStateException("Environment variable IOTEDGE_MODULEGENERATIONID is required");
        }
        if (!authScheme.equalsIgnoreCase(SasTokenAuthScheme)) {
            throw new IllegalStateException("Unsupported authentication scheme. Supported scheme is sasToken.");
        }
        try {
            signatureProvider = new HttpHsmSignatureProvider(edgedUri, DEFAULT_API_VERSION, unixDomainSocketChannel);
        }
        catch (URISyntaxException | NoSuchAlgorithmException e) {
            throw new IotHubClientException(IotHubStatusCode.ERROR, "Could not use Hsm Signature Provider", e);
        }
        try {
            SSLContext sslContext;
            if (gatewayHostname != null && !gatewayHostname.isEmpty()) {
                HttpsHsmTrustBundleProvider trustBundleProvider = new HttpsHsmTrustBundleProvider();
                String trustCertificates = trustBundleProvider.getTrustBundleCerts(edgedUri, DEFAULT_API_VERSION, unixDomainSocketChannel);
                sslContext = IotHubSSLContext.getSSLContextFromString(trustCertificates);
            } else {
                sslContext = new IotHubSSLContext().getSSLContext();
            }
            IotHubSasTokenHsmAuthenticationProvider iotHubAuthenticationProvider = IotHubSasTokenHsmAuthenticationProvider.create(signatureProvider, deviceId, moduleId, hostname, gatewayHostname, generationId, 3600, 85, sslContext);
            if (clientOptions != null && clientOptions.getSslContext() == null) {
                clientOptions = clientOptions.toBuilder().sslContext(sslContext).build();
            } else if (clientOptions == null) {
                clientOptions = ClientOptions.builder().sslContext(sslContext).build();
            } else {
                log.debug("Ignoring trusted certs received from edgelet because custom SSLContext was provided in client options.");
            }
            return new ModuleClient(iotHubAuthenticationProvider, protocol, clientOptions);
        }
        catch (URISyntaxException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IotHubClientException(IotHubStatusCode.ERROR, "Failed to handle the provided certificates", e);
        }
        catch (TransportException e) {
            throw e.toIotHubClientException();
        }
        catch (IOException e) {
            throw new IotHubClientException(IotHubStatusCode.IO_ERROR, e);
        }
    }

    private ModuleClient(IotHubAuthenticationProvider iotHubAuthenticationProvider, IotHubClientProtocol protocol, ClientOptions options) {
        super(iotHubAuthenticationProvider, protocol, options);
        ModuleClient.commonConstructorSetup();
    }

    public void sendEvent(Message message, String outputName) throws IllegalStateException, InterruptedException, IotHubClientException {
        this.sendEvent(message, outputName, 60000);
    }

    public void sendEvent(Message message, String outputName, int timeoutMilliseconds) throws IllegalStateException, InterruptedException, IotHubClientException {
        if (outputName == null || outputName.isEmpty()) {
            throw new IllegalArgumentException("outputName cannot be null or empty");
        }
        message.setOutputName(outputName);
        this.sendEvent(message, timeoutMilliseconds);
    }

    @Override
    public void sendEvent(Message message) throws IllegalArgumentException, InterruptedException, IotHubClientException {
        message.setConnectionModuleId(this.config.getModuleId());
        super.sendEvent(message);
    }

    public void sendEventAsync(Message message, MessageSentCallback callback, Object callbackContext, String outputName) throws IllegalStateException {
        if (outputName == null || outputName.isEmpty()) {
            throw new IllegalArgumentException("outputName cannot be null or empty");
        }
        message.setOutputName(outputName);
        this.sendEventAsync(message, callback, callbackContext);
    }

    @Override
    public void sendEventAsync(Message message, MessageSentCallback callback, Object callbackContext) throws IllegalArgumentException {
        message.setConnectionModuleId(this.config.getModuleId());
        super.sendEventAsync(message, callback, callbackContext);
    }

    public DirectMethodResponse invokeMethod(String deviceId, DirectMethodRequest directMethodRequest) throws IotHubClientException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("DeviceId cannot be null or empty");
        }
        try {
            HttpsTransportManager httpsTransportManager = new HttpsTransportManager(this.config);
            return httpsTransportManager.invokeMethod(directMethodRequest, deviceId, "");
        }
        catch (IotHubServiceException e) {
            throw new IotHubClientException(e.getStatusCode(), "Could not invoke method", e);
        }
        catch (TransportException e) {
            throw new IotHubClientException(IotHubStatusCode.IO_ERROR, "Could not invoke method", e);
        }
        catch (IOException e) {
            throw new IotHubClientException(IotHubStatusCode.IO_ERROR, e);
        }
    }

    public DirectMethodResponse invokeMethod(String deviceId, String moduleId, DirectMethodRequest directMethodRequest) throws IotHubClientException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("DeviceId cannot be null or empty");
        }
        if (moduleId == null || moduleId.isEmpty()) {
            throw new IllegalArgumentException("DeviceId cannot be null or empty");
        }
        try {
            HttpsTransportManager httpsTransportManager = new HttpsTransportManager(this.config);
            return httpsTransportManager.invokeMethod(directMethodRequest, deviceId, moduleId);
        }
        catch (IotHubServiceException e) {
            throw new IotHubClientException(e.getStatusCode(), "Could not invoke method", e);
        }
        catch (TransportException e) {
            throw new IotHubClientException(IotHubStatusCode.IO_ERROR, "Could not invoke method", e);
        }
        catch (IOException e) {
            throw new IotHubClientException(IotHubStatusCode.IO_ERROR, e);
        }
    }

    public ModuleClient setMessageCallback(MessageCallback callback, Object context) {
        this.setMessageCallbackInternal(callback, context);
        return this;
    }

    public ModuleClient setMessageCallback(String inputName, MessageCallback callback, Object context) {
        if (inputName == null || inputName.isEmpty()) {
            throw new IllegalArgumentException("InputName must not be null or empty");
        }
        if (callback == null && context != null) {
            throw new IllegalArgumentException("Cannot give non-null context for a null callback.");
        }
        this.config.setMessageCallback(inputName, callback, context);
        return this;
    }

    private static void commonConstructorVerifications(IotHubClientProtocol protocol, ClientConfiguration config) {
        if (protocol == IotHubClientProtocol.HTTPS) {
            throw new UnsupportedOperationException("Only MQTT, MQTT_WS, AMQPS and AMQPS_WS are supported for ModuleClient.");
        }
        if (config.getModuleId() == null || config.getModuleId().isEmpty()) {
            throw new IllegalArgumentException("Connection string must contain field for ModuleId");
        }
    }

    private static void commonConstructorSetup() {
        log.debug("Initialized a ModuleClient instance using SDK version {}", (Object)TransportUtils.CLIENT_VERSION);
    }
}

