/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageProperty {
    private static final Logger log = LoggerFactory.getLogger(MessageProperty.class);
    public static final Set<String> RESERVED_PROPERTY_NAMES;
    public static final String OUTPUT_NAME_PROPERTY = "iothub-outputname";
    public static final String CONNECTION_DEVICE_ID = "iothub-connection-device-id";
    public static final String CONNECTION_MODULE_ID = "iothub-connection-module-id";
    public static final String IOTHUB_CONTENT_ENCODING = "iothub-contentencoding";
    public static final String IOTHUB_CONTENT_TYPE = "iothub-contenttype";
    public static final String IOTHUB_CREATION_TIME_UTC = "iothub-creation-time-utc";
    public static final String IOTHUB_SECURITY_INTERFACE_ID = "iothub-interface-id";
    public static final String IOTHUB_SECURITY_INTERFACE_ID_VALUE = "urn:azureiot:Security:SecurityAgent:1";
    public static final String COMPONENT_ID = "dt-subject";
    private final String name;
    private final String value;

    public MessageProperty(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Property argument 'name' cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Property argument 'value' cannot be null.");
        }
        if (RESERVED_PROPERTY_NAMES.contains(name)) {
            String errMsg = String.format("%s is a reserved IoT Hub message property name.%n", name);
            throw new IllegalArgumentException(errMsg);
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasSameName(String name) {
        boolean nameMatches = false;
        if (this.getName().equalsIgnoreCase(name)) {
            nameMatches = true;
        }
        return nameMatches;
    }

    public static boolean isValidAppProperty(String name, String value) {
        return !RESERVED_PROPERTY_NAMES.contains(name);
    }

    public static boolean isValidSystemProperty(String name, String value) {
        return RESERVED_PROPERTY_NAMES.contains(name);
    }

    protected MessageProperty() {
        this.name = null;
        this.value = null;
    }

    static {
        HashSet<String> reservedPropertyNames = new HashSet<String>();
        reservedPropertyNames.add("iothub-enqueuedtime");
        reservedPropertyNames.add("iothub-messagelocktoken");
        reservedPropertyNames.add("iothub-sequencenumber");
        reservedPropertyNames.add("iothub-operation");
        reservedPropertyNames.add("iothub-partition-key");
        reservedPropertyNames.add("iothub-ack");
        reservedPropertyNames.add("iothub-connection-auth-method");
        reservedPropertyNames.add("iothub-connection-auth-generation-id");
        reservedPropertyNames.add("iothub-messageid");
        reservedPropertyNames.add("iothub-correlationid");
        reservedPropertyNames.add("iothub-userid");
        reservedPropertyNames.add("iothub-to");
        reservedPropertyNames.add("iothub-content-type");
        reservedPropertyNames.add(IOTHUB_CONTENT_TYPE);
        reservedPropertyNames.add("iothub-content-encoding");
        reservedPropertyNames.add(IOTHUB_CONTENT_ENCODING);
        reservedPropertyNames.add("iothub-absolute-expiry-time");
        reservedPropertyNames.add("IoThub-methodname");
        reservedPropertyNames.add("connectionDeviceId");
        reservedPropertyNames.add("connectionModuleId");
        reservedPropertyNames.add(OUTPUT_NAME_PROPERTY);
        reservedPropertyNames.add("iothub-inputname");
        reservedPropertyNames.add(CONNECTION_DEVICE_ID);
        reservedPropertyNames.add(CONNECTION_MODULE_ID);
        RESERVED_PROPERTY_NAMES = Collections.unmodifiableSet(reservedPropertyNames);
    }
}

