/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.BatchMessage;
import com.microsoft.azure.sdk.iot.device.ClientConfiguration;
import com.microsoft.azure.sdk.iot.device.ClientOptions;
import com.microsoft.azure.sdk.iot.device.DeviceIO;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStatusChangeCallback;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageSentCallback;
import com.microsoft.azure.sdk.iot.device.MessagesSentCallback;
import com.microsoft.azure.sdk.iot.device.ProductInfo;
import com.microsoft.azure.sdk.iot.device.SasTokenProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.exceptions.IotHubClientException;
import com.microsoft.azure.sdk.iot.device.transport.RetryPolicy;
import com.microsoft.azure.sdk.iot.device.twin.DesiredPropertiesCallback;
import com.microsoft.azure.sdk.iot.device.twin.DeviceTwin;
import com.microsoft.azure.sdk.iot.device.twin.DirectMethod;
import com.microsoft.azure.sdk.iot.device.twin.GetTwinCallback;
import com.microsoft.azure.sdk.iot.device.twin.GetTwinCorrelatingMessageCallback;
import com.microsoft.azure.sdk.iot.device.twin.MethodCallback;
import com.microsoft.azure.sdk.iot.device.twin.ReportedPropertiesCallback;
import com.microsoft.azure.sdk.iot.device.twin.ReportedPropertiesUpdateCorrelatingMessageCallback;
import com.microsoft.azure.sdk.iot.device.twin.ReportedPropertiesUpdateResponse;
import com.microsoft.azure.sdk.iot.device.twin.SubscriptionAcknowledgedCallback;
import com.microsoft.azure.sdk.iot.device.twin.Twin;
import com.microsoft.azure.sdk.iot.device.twin.TwinCollection;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalClient {
    private static final Logger log = LoggerFactory.getLogger(InternalClient.class);
    private static final String TWIN_OVER_HTTP_ERROR_MESSAGE = "Twin operations are only supported over MQTT, MQTT_WS, AMQPS, and AMQPS_WS";
    private static final String METHODS_OVER_HTTP_ERROR_MESSAGE = "Direct methods are only supported over MQTT, MQTT_WS, AMQPS, and AMQPS_WS";
    protected static final int DEFAULT_TIMEOUT_MILLISECONDS = 60000;
    ClientConfiguration config;
    private DeviceIO deviceIO;
    boolean isMultiplexed = false;
    private IotHubConnectionStatusChangeCallback connectionStatusChangeCallback;
    private Object connectionStatusChangeCallbackContext;
    private DeviceTwin twin;
    private DirectMethod method;

    InternalClient(IotHubConnectionString iotHubConnectionString, IotHubClientProtocol protocol, ClientOptions clientOptions) {
        this.commonConstructorVerification(iotHubConnectionString, protocol);
        this.config = new ClientConfiguration(iotHubConnectionString, protocol, clientOptions);
        this.deviceIO = new DeviceIO(this.config);
        this.setClientOptionValues(clientOptions);
    }

    InternalClient(IotHubAuthenticationProvider iotHubAuthenticationProvider, IotHubClientProtocol protocol, ClientOptions options) {
        this.config = new ClientConfiguration(iotHubAuthenticationProvider, protocol, options);
        this.deviceIO = new DeviceIO(this.config);
        this.setClientOptionValues(options);
    }

    InternalClient(String uri, String deviceId, SecurityProvider securityProvider, IotHubClientProtocol protocol, ClientOptions clientOptions) throws IOException {
        if (protocol == null) {
            throw new IllegalArgumentException("The transport protocol cannot be null");
        }
        if (securityProvider == null) {
            throw new IllegalArgumentException("securityProvider cannot be null");
        }
        if (uri == null || uri.isEmpty()) {
            throw new IllegalArgumentException("URI cannot be null or empty");
        }
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("deviceId cannot be null or empty");
        }
        IotHubConnectionString connectionString = new IotHubConnectionString(uri, deviceId, null, null);
        this.config = new ClientConfiguration(connectionString, securityProvider, protocol, clientOptions);
        this.deviceIO = new DeviceIO(this.config);
        this.setClientOptionValues(clientOptions);
    }

    InternalClient(String hostName, String deviceId, String moduleId, SasTokenProvider sasTokenProvider, IotHubClientProtocol protocol, ClientOptions clientOptions) {
        if (hostName == null) {
            throw new IllegalArgumentException("Host name cannot be null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("Protocol cannot be null.");
        }
        this.config = new ClientConfiguration(hostName, sasTokenProvider, protocol, clientOptions, deviceId, moduleId);
        this.deviceIO = new DeviceIO(this.config);
        this.setClientOptionValues(clientOptions);
    }

    private void setClientOptionValues(ClientOptions clientOptions) {
        if (clientOptions != null) {
            if (clientOptions.getMessagesSentPerSendInterval() <= 0) {
                throw new IllegalArgumentException("ClientOption messagesSentPerSendInterval must be greater than 0");
            }
            if (clientOptions.getSendInterval() <= 0) {
                throw new IllegalArgumentException("ClientOption sendInterval must be greater than 0");
            }
            if (clientOptions.getReceiveInterval() <= 0) {
                throw new IllegalArgumentException("ClientOption receiveInterval must be greater than 0");
            }
            if (clientOptions.getProxySettings() != null) {
                if (this.isMultiplexed) {
                    throw new UnsupportedOperationException("Cannot set the proxy settings of a multiplexed device. Proxy settings for the multiplexed connection can only be set at multiplexing client constructor time.");
                }
                this.verifyRegisteredIfMultiplexing();
            }
            this.deviceIO.setMaxNumberOfMessagesSentPerSendThread(clientOptions.getMessagesSentPerSendInterval());
            this.deviceIO.setSendPeriodInMilliseconds(clientOptions.getSendInterval());
            this.deviceIO.setReceivePeriodInMilliseconds(clientOptions.getReceiveInterval());
        }
    }

    InternalClient() {
        this.config = null;
        this.deviceIO = null;
    }

    public void open(boolean withRetry) throws IotHubClientException {
        this.deviceIO.open(withRetry);
    }

    public void close() {
        this.deviceIO.close();
        this.method = null;
        this.twin = null;
    }

    public void sendEvent(Message message) throws InterruptedException, IllegalStateException, IotHubClientException {
        this.sendEvent(message, 60000);
    }

    public void sendEvent(Message message, int timeoutMilliseconds) throws InterruptedException, IllegalStateException, IotHubClientException {
        this.verifyRegisteredIfMultiplexing();
        message.setConnectionDeviceId(this.config.getDeviceId());
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference iotHubClientExceptionReference = new AtomicReference();
        MessageSentCallback eventCallback = (sentMessage, exception, callbackContext) -> {
            iotHubClientExceptionReference.set(exception);
            latch.countDown();
        };
        this.sendEventAsync(message, eventCallback, null);
        if (timeoutMilliseconds == 0) {
            latch.await();
        } else {
            boolean timedOut;
            boolean bl = timedOut = !latch.await(timeoutMilliseconds, TimeUnit.MILLISECONDS);
            if (timedOut) {
                throw new IotHubClientException(IotHubStatusCode.DEVICE_OPERATION_TIMED_OUT, "Timed out waiting for service to acknowledge telemetry");
            }
        }
        IotHubClientException exception2 = (IotHubClientException)iotHubClientExceptionReference.get();
        if (exception2 != null) {
            throw new IotHubClientException(exception2.getStatusCode(), exception2.getMessage(), exception2);
        }
    }

    public void sendEvents(List<Message> messages) throws InterruptedException, IllegalStateException, IotHubClientException, UnsupportedOperationException {
        this.sendEvents(messages, 60000);
    }

    public void sendEvents(List<Message> messages, int timeoutMilliseconds) throws InterruptedException, IllegalStateException, IotHubClientException, UnsupportedOperationException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference iotHubClientExceptionReference = new AtomicReference();
        MessagesSentCallback eventCallback = (sentMessages, exception, callbackContext) -> {
            iotHubClientExceptionReference.set(exception);
            latch.countDown();
        };
        this.sendEventsAsync(messages, eventCallback, null);
        if (timeoutMilliseconds == 0) {
            latch.await();
        } else {
            boolean timedOut;
            boolean bl = timedOut = !latch.await(timeoutMilliseconds, TimeUnit.MILLISECONDS);
            if (timedOut) {
                throw new IotHubClientException(IotHubStatusCode.DEVICE_OPERATION_TIMED_OUT, "Timed out waiting for service to acknowledge telemetry");
            }
        }
        IotHubClientException exception2 = (IotHubClientException)iotHubClientExceptionReference.get();
        if (exception2 != null) {
            throw new IotHubClientException(exception2.getStatusCode(), exception2.getMessage(), exception2);
        }
    }

    public void subscribeToDesiredProperties(DesiredPropertiesCallback desiredPropertiesCallback, Object desiredPropertiesCallbackContext) throws InterruptedException, IllegalStateException, IotHubClientException {
        this.subscribeToDesiredProperties(desiredPropertiesCallback, desiredPropertiesCallbackContext, 60000);
    }

    public void subscribeToDesiredProperties(DesiredPropertiesCallback desiredPropertiesCallback, Object desiredPropertiesCallbackContext, int timeoutMilliseconds) throws InterruptedException, IllegalStateException, IotHubClientException {
        AtomicReference iotHubClientExceptionReference = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        this.subscribeToDesiredPropertiesAsync(desiredPropertiesCallback, desiredPropertiesCallbackContext, (exception, context) -> {
            iotHubClientExceptionReference.set(exception);
            latch.countDown();
        }, null);
        if (timeoutMilliseconds == 0) {
            latch.await();
        } else {
            boolean timedOut;
            boolean bl = timedOut = !latch.await(timeoutMilliseconds, TimeUnit.MILLISECONDS);
            if (timedOut) {
                throw new IotHubClientException(IotHubStatusCode.DEVICE_OPERATION_TIMED_OUT, "Timed out waiting for service to acknowledge desired properties subscription request");
            }
        }
        IotHubClientException exception2 = (IotHubClientException)iotHubClientExceptionReference.get();
        if (exception2 != null) {
            throw new IotHubClientException(exception2.getStatusCode(), exception2.getMessage(), exception2);
        }
    }

    public ReportedPropertiesUpdateResponse updateReportedProperties(TwinCollection reportedProperties) throws InterruptedException, IllegalStateException, IotHubClientException {
        return this.updateReportedProperties(reportedProperties, 60000);
    }

    public ReportedPropertiesUpdateResponse updateReportedProperties(TwinCollection reportedProperties, int timeoutMilliseconds) throws InterruptedException, IllegalStateException, IotHubClientException {
        AtomicReference iotHubClientExceptionAtomicReference = new AtomicReference();
        AtomicReference responseAtomicReference = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        this.updateReportedPropertiesAsync(reportedProperties, (IotHubStatusCode statusCode, ReportedPropertiesUpdateResponse response, IotHubClientException e, Object callbackContext) -> {
            iotHubClientExceptionAtomicReference.set(e);
            responseAtomicReference.set(response);
            latch.countDown();
        }, null);
        if (timeoutMilliseconds == 0) {
            latch.await();
        } else {
            boolean timedOut;
            boolean bl = timedOut = !latch.await(timeoutMilliseconds, TimeUnit.MILLISECONDS);
            if (timedOut) {
                throw new IotHubClientException(IotHubStatusCode.DEVICE_OPERATION_TIMED_OUT, "Timed out waiting for service to acknowledge reported properties update");
            }
        }
        IotHubClientException exception = (IotHubClientException)iotHubClientExceptionAtomicReference.get();
        if (exception != null) {
            throw new IotHubClientException(exception.getStatusCode(), exception.getMessage(), exception);
        }
        return (ReportedPropertiesUpdateResponse)responseAtomicReference.get();
    }

    public Twin getTwin() throws InterruptedException, IllegalStateException, IotHubClientException {
        return this.getTwin(60000);
    }

    public Twin getTwin(int timeoutMilliseconds) throws InterruptedException, IllegalStateException, IotHubClientException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference twinAtomicReference = new AtomicReference();
        AtomicReference iotHubClientExceptionReference = new AtomicReference();
        this.getTwinAsync((Twin twin, IotHubClientException exception, Object callbackContext) -> {
            twinAtomicReference.set(twin);
            iotHubClientExceptionReference.set(exception);
            latch.countDown();
        }, null);
        if (timeoutMilliseconds == 0) {
            latch.await();
        } else {
            boolean timedOut;
            boolean bl = timedOut = !latch.await(timeoutMilliseconds, TimeUnit.MILLISECONDS);
            if (timedOut) {
                throw new IotHubClientException(IotHubStatusCode.DEVICE_OPERATION_TIMED_OUT, "Timed out waiting for service to respond to getTwin request");
            }
        }
        IotHubClientException exception2 = (IotHubClientException)iotHubClientExceptionReference.get();
        if (exception2 != null) {
            throw new IotHubClientException(exception2.getStatusCode(), exception2.getMessage(), exception2);
        }
        return (Twin)twinAtomicReference.get();
    }

    public void subscribeToMethods(MethodCallback methodCallback, Object methodCallbackContext) throws IllegalStateException, InterruptedException, IotHubClientException {
        this.subscribeToMethods(methodCallback, methodCallbackContext, 60000);
    }

    public void subscribeToMethods(MethodCallback methodCallback, Object methodCallbackContext, int timeoutMilliseconds) throws IllegalStateException, InterruptedException, IotHubClientException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference iotHubClientExceptionReference = new AtomicReference();
        this.subscribeToMethodsAsync(methodCallback, methodCallbackContext, (exception, callbackContext) -> {
            iotHubClientExceptionReference.set(exception);
            latch.countDown();
        }, null);
        if (timeoutMilliseconds == 0) {
            latch.await();
        } else {
            boolean timedOut;
            boolean bl = timedOut = !latch.await(timeoutMilliseconds, TimeUnit.MILLISECONDS);
            if (timedOut) {
                throw new IotHubClientException(IotHubStatusCode.DEVICE_OPERATION_TIMED_OUT, "Timed out waiting for service to respond to direct method subscription request");
            }
        }
        IotHubClientException exception2 = (IotHubClientException)iotHubClientExceptionReference.get();
        if (exception2 != null) {
            throw new IotHubClientException(exception2.getStatusCode(), exception2.getMessage(), exception2);
        }
    }

    public void sendEventAsync(Message message, MessageSentCallback callback, Object callbackContext) throws IllegalStateException {
        this.verifyRegisteredIfMultiplexing();
        message.setConnectionDeviceId(this.config.getDeviceId());
        this.deviceIO.sendEventAsync(message, callback, callbackContext, this.config.getDeviceId());
    }

    public void sendEventsAsync(List<Message> messages, MessagesSentCallback callback, Object callbackContext) throws IllegalStateException, UnsupportedOperationException {
        Message message2;
        this.verifyRegisteredIfMultiplexing();
        for (Message message2 : messages) {
            message2.setConnectionDeviceId(this.config.getDeviceId());
        }
        MessageSentCallback messageSentCallback = (sentMessage, clientException, callbackContext1) -> callback.onMessagesSent(messages, clientException, callbackContext1);
        if (this.config.getProtocol() != IotHubClientProtocol.HTTPS) {
            throw new UnsupportedOperationException("Batch messaging is only supported over HTTPS");
        }
        message2 = new BatchMessage(messages);
        this.deviceIO.sendEventAsync(message2, messageSentCallback, callbackContext, this.config.getDeviceId());
    }

    public void subscribeToDesiredPropertiesAsync(DesiredPropertiesCallback desiredPropertiesCallback, Object desiredPropertiesCallbackContext, SubscriptionAcknowledgedCallback subscriptionAcknowledgedCallback, Object desiredPropertiesSubscriptionCallbackContext) throws IllegalStateException {
        this.verifyRegisteredIfMultiplexing();
        this.verifyTwinOperationsAreSupported();
        if (!this.deviceIO.isOpen()) {
            throw new IllegalStateException("Open the client connection before using it");
        }
        this.twin = new DeviceTwin(this);
        this.twin.subscribeToDesiredPropertiesAsync(subscriptionAcknowledgedCallback, desiredPropertiesSubscriptionCallbackContext, desiredPropertiesCallback, desiredPropertiesCallbackContext);
    }

    public void updateReportedPropertiesAsync(TwinCollection reportedProperties, final ReportedPropertiesCallback reportedPropertiesCallback, Object callbackContext) throws IllegalStateException {
        this.updateReportedPropertiesAsync(reportedProperties, new ReportedPropertiesUpdateCorrelatingMessageCallback(){

            @Override
            public void onRequestQueued(Message message, Object callbackContext) {
            }

            @Override
            public void onRequestSent(Message message, Object callbackContext) {
            }

            @Override
            public void onRequestAcknowledged(Message message, Object callbackContext, IotHubClientException e) {
            }

            @Override
            public void onResponseReceived(Message message, Object callbackContext, IotHubStatusCode statusCode, ReportedPropertiesUpdateResponse response, IotHubClientException e) {
                reportedPropertiesCallback.onReportedPropertiesUpdateAcknowledged(statusCode, response, e, callbackContext);
            }

            @Override
            public void onResponseAcknowledged(Message message, Object callbackContext) {
            }
        }, callbackContext);
    }

    public void updateReportedPropertiesAsync(TwinCollection reportedProperties, ReportedPropertiesUpdateCorrelatingMessageCallback reportedPropertiesUpdateCorrelatingMessageCallback, Object callbackContext) throws IllegalStateException {
        if (this.twin == null) {
            this.twin = new DeviceTwin(this);
        }
        this.twin.updateReportedPropertiesAsync(reportedProperties, reportedPropertiesUpdateCorrelatingMessageCallback, callbackContext);
    }

    public void getTwinAsync(final GetTwinCallback twinCallback, Object callbackContext) throws IllegalStateException {
        this.getTwinAsync(new GetTwinCorrelatingMessageCallback(){

            @Override
            public void onRequestQueued(Message message, Object callbackContext) {
            }

            @Override
            public void onRequestSent(Message message, Object callbackContext) {
            }

            @Override
            public void onRequestAcknowledged(Message message, Object callbackContext, IotHubClientException e) {
            }

            @Override
            public void onResponseReceived(Twin twin, Message message, Object callbackContext, IotHubStatusCode statusCode, IotHubClientException e) {
                log.trace("Executing twin callback for message {}", (Object)message);
                twinCallback.onTwinReceived(twin, e, callbackContext);
                log.trace("Twin callback returned for message {}", (Object)message);
            }

            @Override
            public void onResponseAcknowledged(Message message, Object callbackContext) {
            }
        }, callbackContext);
    }

    public void getTwinAsync(GetTwinCorrelatingMessageCallback twinCallback, Object callbackContext) throws IllegalStateException {
        if (!this.deviceIO.isOpen()) {
            throw new IllegalStateException("Open the client connection before using it");
        }
        if (this.twin == null) {
            this.twin = new DeviceTwin(this);
        }
        this.twin.getTwinAsync(twinCallback, callbackContext);
    }

    public void subscribeToMethodsAsync(MethodCallback methodCallback, Object methodCallbackContext, SubscriptionAcknowledgedCallback methodStatusCallback, Object methodStatusCallbackContext) throws IllegalStateException {
        this.verifyRegisteredIfMultiplexing();
        this.verifyMethodsAreSupported();
        if (!this.deviceIO.isOpen()) {
            throw new IllegalStateException("Open the client connection before using it");
        }
        if (methodCallback == null || methodStatusCallback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        this.method = new DirectMethod(this, methodStatusCallback, methodStatusCallbackContext);
        this.method.subscribeToDirectMethods(methodCallback, methodCallbackContext);
    }

    public void setConnectionStatusChangeCallback(IotHubConnectionStatusChangeCallback callback, Object callbackContext) {
        this.connectionStatusChangeCallback = callback;
        this.connectionStatusChangeCallbackContext = callbackContext;
        if (this.deviceIO != null) {
            this.deviceIO.setConnectionStatusChangeCallback(callback, callbackContext, this.getConfig().getDeviceId());
        }
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.config.setRetryPolicy(retryPolicy);
    }

    public void setOperationTimeout(long timeout) throws IllegalArgumentException {
        this.config.setOperationTimeout(timeout);
    }

    public ProductInfo getProductInfo() {
        return this.config.getProductInfo();
    }

    public ClientConfiguration getConfig() {
        return this.config;
    }

    void markTwinAsUnsubscribed() {
        this.twin = null;
    }

    void markMethodsAsUnsubscribed() {
        this.method = null;
    }

    void setMessageCallbackInternal(MessageCallback callback, Object context) {
        if (callback == null && context != null) {
            throw new IllegalArgumentException("Cannot give non-null context for a null callback.");
        }
        this.config.setMessageCallback(callback, context);
    }

    DeviceIO getDeviceIO() {
        return this.deviceIO;
    }

    void setDeviceIO(DeviceIO deviceIO) {
        this.deviceIO = deviceIO;
        if (this.deviceIO != null && this.connectionStatusChangeCallback != null) {
            this.deviceIO.setConnectionStatusChangeCallback(this.connectionStatusChangeCallback, this.connectionStatusChangeCallbackContext, this.getConfig().getDeviceId());
        }
    }

    void setAsMultiplexed() {
        this.isMultiplexed = true;
    }

    private void commonConstructorVerification(IotHubConnectionString connectionString, IotHubClientProtocol protocol) {
        if (connectionString == null) {
            throw new IllegalArgumentException("Connection string cannot be null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("Protocol cannot be null.");
        }
        String gatewayHostName = connectionString.getGatewayHostName();
        if (gatewayHostName != null && !gatewayHostName.isEmpty() && protocol == IotHubClientProtocol.HTTPS) {
            throw new UnsupportedOperationException("Communication with edgehub only supported by MQTT/MQTT_WS and AMQPS/AMQPS_WS");
        }
    }

    private void verifyRegisteredIfMultiplexing() {
        if (this.deviceIO == null && this.isMultiplexed) {
            throw new UnsupportedOperationException("Must re-register this client to a multiplexing client before using it");
        }
    }

    private void verifyTwinOperationsAreSupported() {
        if (this.config.getProtocol() == IotHubClientProtocol.HTTPS) {
            throw new UnsupportedOperationException(TWIN_OVER_HTTP_ERROR_MESSAGE);
        }
    }

    private void verifyMethodsAreSupported() {
        if (this.config.getProtocol() == IotHubClientProtocol.HTTPS) {
            throw new UnsupportedOperationException(METHODS_OVER_HTTP_ERROR_MESSAGE);
        }
    }
}

