/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.ClientConfiguration;
import com.microsoft.azure.sdk.iot.device.ConnectionStatusChangeContext;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStatusChangeCallback;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStatusChangeReason;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageSentCallback;
import com.microsoft.azure.sdk.iot.device.ProxySettings;
import com.microsoft.azure.sdk.iot.device.exceptions.IotHubClientException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubConnectionStatus;
import com.microsoft.azure.sdk.iot.device.transport.IotHubReceiveTask;
import com.microsoft.azure.sdk.iot.device.transport.IotHubReconnectTask;
import com.microsoft.azure.sdk.iot.device.transport.IotHubSendTask;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransport;
import com.microsoft.azure.sdk.iot.device.transport.RetryPolicy;
import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DeviceIO
implements IotHubConnectionStatusChangeCallback {
    private static final Logger log = LoggerFactory.getLogger(DeviceIO.class);
    private static final int SEND_PERIOD_MILLIS = 10;
    private static final int RECEIVE_PERIOD_MILLIS = 10;
    private long sendPeriodInMilliseconds = 10L;
    private long receivePeriodInMilliseconds = 10L;
    private final IotHubTransport transport;
    private final IotHubSendTask sendTask;
    private final IotHubReceiveTask receiveTask;
    private final IotHubReconnectTask reconnectTask;
    private ScheduledExecutorService receiveTaskScheduler;
    private ScheduledExecutorService sendTaskScheduler;
    private ScheduledExecutorService reconnectTaskScheduler;
    private IotHubConnectionStatus state;
    private final Object stateLock = new Object();

    DeviceIO(ClientConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null.");
        }
        IotHubClientProtocol protocol = config.getProtocol();
        config.setUseWebsocket(protocol == IotHubClientProtocol.AMQPS_WS || protocol == IotHubClientProtocol.MQTT_WS);
        this.state = IotHubConnectionStatus.DISCONNECTED;
        this.transport = new IotHubTransport(config, this, false);
        this.state = IotHubConnectionStatus.DISCONNECTED;
        this.sendTask = new IotHubSendTask(this.transport, config.isUsingIdentifiableThreadNames(), config.getThreadNamePrefix(), config.getThreadNameSuffix());
        this.receiveTask = new IotHubReceiveTask(this.transport, config.isUsingIdentifiableThreadNames(), config.getThreadNamePrefix(), config.getThreadNameSuffix());
        this.reconnectTask = new IotHubReconnectTask(this.transport, config.isUsingIdentifiableThreadNames(), config.getThreadNamePrefix(), config.getThreadNameSuffix());
    }

    DeviceIO(String hostName, IotHubClientProtocol protocol, SSLContext sslContext, ProxySettings proxySettings, int keepAliveInterval, int sendInterval, boolean useIdentifiableThreadNames, String threadNamePrefix, String threadNameSuffix, long messageExpirationCheckPeriod) {
        this.state = IotHubConnectionStatus.DISCONNECTED;
        this.transport = new IotHubTransport(hostName, protocol, sslContext, proxySettings, this, keepAliveInterval, sendInterval, useIdentifiableThreadNames, threadNamePrefix, threadNameSuffix, messageExpirationCheckPeriod);
        this.sendTask = new IotHubSendTask(this.transport, useIdentifiableThreadNames, threadNamePrefix, threadNameSuffix);
        this.receiveTask = new IotHubReceiveTask(this.transport, useIdentifiableThreadNames, threadNamePrefix, threadNameSuffix);
        this.reconnectTask = new IotHubReconnectTask(this.transport, useIdentifiableThreadNames, threadNamePrefix, threadNameSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open(boolean withRetry) throws IotHubClientException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isOpen()) {
                return;
            }
            try {
                this.transport.open(withRetry);
            }
            catch (TransportException e) {
                throw e.toIotHubClientException();
            }
        }
    }

    void registerMultiplexedDeviceClient(List<ClientConfiguration> configs, long timeoutMilliseconds) throws InterruptedException, IotHubClientException {
        this.transport.registerMultiplexedDeviceClient(configs, timeoutMilliseconds);
    }

    void unregisterMultiplexedDeviceClient(List<ClientConfiguration> configs, long timeoutMilliseconds) throws InterruptedException, IotHubClientException {
        this.transport.unregisterMultiplexedDeviceClient(configs, timeoutMilliseconds);
    }

    void setMultiplexingRetryPolicy(RetryPolicy retryPolicy) {
        this.transport.setMultiplexingRetryPolicy(retryPolicy);
    }

    void setMaxNumberOfMessagesSentPerSendThread(int maxNumberOfMessagesSentPerSendThread) {
        this.transport.setMaxNumberOfMessagesSentPerSendThread(maxNumberOfMessagesSentPerSendThread);
    }

    private void startWorkerThreads() {
        this.stopSendAndReceiveThreads();
        log.debug("Starting worker threads");
        this.sendTaskScheduler = Executors.newScheduledThreadPool(1);
        this.receiveTaskScheduler = Executors.newScheduledThreadPool(1);
        this.sendTaskScheduler.scheduleWithFixedDelay(this.sendTask, 0L, this.sendPeriodInMilliseconds, TimeUnit.MILLISECONDS);
        this.receiveTaskScheduler.scheduleWithFixedDelay(this.receiveTask, 0L, this.receivePeriodInMilliseconds, TimeUnit.MILLISECONDS);
        if (this.reconnectTaskScheduler == null) {
            this.reconnectTaskScheduler = Executors.newScheduledThreadPool(1);
            this.reconnectTaskScheduler.scheduleWithFixedDelay(this.reconnectTask, 0L, this.receivePeriodInMilliseconds, TimeUnit.MILLISECONDS);
        }
        this.state = IotHubConnectionStatus.CONNECTED;
    }

    private void stopSendAndReceiveThreads() {
        if (this.sendTaskScheduler != null) {
            log.trace("Shutting down sendTaskScheduler");
            this.sendTaskScheduler.shutdownNow();
            this.sendTaskScheduler = null;
        }
        if (this.receiveTaskScheduler != null) {
            log.trace("Shutting down receiveTaskScheduler");
            this.receiveTaskScheduler.shutdownNow();
            this.receiveTaskScheduler = null;
        }
    }

    private void stopReconnectThreads() {
        if (this.reconnectTaskScheduler != null) {
            log.trace("Shutting down reconnectTaskScheduler");
            this.reconnectTaskScheduler.shutdownNow();
            this.reconnectTaskScheduler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.transport.setClosing(true);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == IotHubConnectionStatus.DISCONNECTED) {
                return;
            }
            this.transport.close(IotHubConnectionStatusChangeReason.CLIENT_CLOSE, null);
            this.state = IotHubConnectionStatus.DISCONNECTED;
        }
    }

    void sendEventAsync(Message message, MessageSentCallback callback, Object callbackContext, String deviceId) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Cannot send event from a client that is closed.");
        }
        if (message == null) {
            throw new IllegalArgumentException("Cannot send message 'null'.");
        }
        if (deviceId != null) {
            message.setConnectionDeviceId(deviceId);
        }
        this.transport.addMessage(message, callback, callbackContext, deviceId);
    }

    void setReceivePeriodInMilliseconds(long newIntervalInMilliseconds) {
        if (newIntervalInMilliseconds <= 0L) {
            throw new IllegalArgumentException("receive interval can not be zero or negative");
        }
        this.receivePeriodInMilliseconds = newIntervalInMilliseconds;
        if (this.receiveTaskScheduler != null) {
            this.receiveTaskScheduler.shutdown();
            this.receiveTaskScheduler = Executors.newScheduledThreadPool(1);
            this.receiveTaskScheduler.scheduleAtFixedRate(this.receiveTask, 0L, this.receivePeriodInMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    void setSendPeriodInMilliseconds(long newIntervalInMilliseconds) {
        if (newIntervalInMilliseconds <= 0L) {
            throw new IllegalArgumentException("send interval can not be zero or negative");
        }
        this.sendPeriodInMilliseconds = newIntervalInMilliseconds;
        if (this.sendTaskScheduler != null) {
            this.sendTaskScheduler.shutdown();
            this.sendTaskScheduler = Executors.newScheduledThreadPool(1);
            this.sendTaskScheduler.scheduleAtFixedRate(this.sendTask, 0L, this.sendPeriodInMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    IotHubClientProtocol getProtocol() {
        return this.transport.getProtocol();
    }

    boolean isOpen() {
        return this.state == IotHubConnectionStatus.CONNECTED || this.state == IotHubConnectionStatus.DISCONNECTED_RETRYING;
    }

    void setConnectionStatusChangeCallback(IotHubConnectionStatusChangeCallback statusChangeCallback, Object callbackContext, String deviceId) {
        this.transport.setConnectionStatusChangeCallback(statusChangeCallback, callbackContext, deviceId);
    }

    void setMultiplexingConnectionStateCallback(IotHubConnectionStatusChangeCallback callback, Object callbackContext) {
        this.transport.setMultiplexingConnectionStateCallback(callback, callbackContext);
    }

    @Override
    public void onStatusChanged(ConnectionStatusChangeContext connectionStatusChangeContext) {
        IotHubConnectionStatus status = connectionStatusChangeContext.getNewStatus();
        IotHubConnectionStatusChangeReason statusChangeReason = connectionStatusChangeContext.getNewStatusReason();
        log.trace("DeviceIO notified of status {} with reason {}", (Object)status, (Object)statusChangeReason);
        if (status == this.state) {
            return;
        }
        if (status == IotHubConnectionStatus.DISCONNECTED || status == IotHubConnectionStatus.DISCONNECTED_RETRYING) {
            this.stopSendAndReceiveThreads();
            if (status == IotHubConnectionStatus.DISCONNECTED) {
                this.stopReconnectThreads();
            }
        } else if (status == IotHubConnectionStatus.CONNECTED) {
            this.startWorkerThreads();
        }
        this.state = status;
    }
}

