/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageProperty;
import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.Mqtt;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttMessageListener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;

class MqttMessaging
extends Mqtt {
    private final String moduleId;
    private final String eventsSubscribeTopic;
    private final String inputsSubscribeTopic;
    private final String publishTopic;
    private final boolean isEdgeHub;

    public MqttMessaging(String deviceId, MqttMessageListener messageListener, String moduleId, boolean isEdgeHub, MqttConnectOptions connectOptions, Map<Integer, Message> unacknowledgedSentMessages, Queue<Pair<String, MqttMessage>> receivedMessages) {
        super(messageListener, deviceId, connectOptions, unacknowledgedSentMessages, receivedMessages);
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("Device id cannot be null or empty");
        }
        if (moduleId == null || moduleId.isEmpty()) {
            this.publishTopic = "devices/" + deviceId + "/messages/events/";
            this.eventsSubscribeTopic = "devices/" + deviceId + "/messages/devicebound/#";
            this.inputsSubscribeTopic = null;
        } else {
            this.publishTopic = "devices/" + deviceId + "/modules/" + moduleId + "/messages/events/";
            this.eventsSubscribeTopic = "devices/" + deviceId + "/modules/" + moduleId + "/messages/devicebound/#";
            this.inputsSubscribeTopic = "devices/" + deviceId + "/modules/" + moduleId + "/inputs/#";
        }
        this.moduleId = moduleId;
        this.isEdgeHub = isEdgeHub;
    }

    public void start() throws TransportException {
        this.connect();
        if (!this.isEdgeHub) {
            this.subscribe(this.eventsSubscribeTopic);
        } else if (this.moduleId != null && !this.moduleId.isEmpty()) {
            this.subscribe(this.inputsSubscribeTopic);
        }
    }

    public void stop() {
        this.disconnect();
    }

    public void send(Message message) throws TransportException {
        if (message == null || message.getBytes() == null) {
            throw new IllegalArgumentException("Message cannot be null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.publishTopic);
        boolean separatorNeeded = this.appendPropertyIfPresent(stringBuilder, false, "$.mid", message.getMessageId(), false);
        separatorNeeded = this.appendPropertyIfPresent(stringBuilder, separatorNeeded, "$.cid", message.getCorrelationId(), false);
        separatorNeeded = this.appendPropertyIfPresent(stringBuilder, separatorNeeded, "$.uid", message.getUserId(), false);
        separatorNeeded = this.appendPropertyIfPresent(stringBuilder, separatorNeeded, "$.to", message.getTo(), false);
        separatorNeeded = this.appendPropertyIfPresent(stringBuilder, separatorNeeded, "$.on", message.getOutputName(), false);
        separatorNeeded = this.appendPropertyIfPresent(stringBuilder, separatorNeeded, "$.cdid", message.getConnectionDeviceId(), false);
        separatorNeeded = this.appendPropertyIfPresent(stringBuilder, separatorNeeded, "$.cmid", message.getConnectionModuleId(), false);
        separatorNeeded = this.appendPropertyIfPresent(stringBuilder, separatorNeeded, "$.ce", message.getContentEncoding(), false);
        separatorNeeded = this.appendPropertyIfPresent(stringBuilder, separatorNeeded, "$.ct", message.getContentType(), false);
        separatorNeeded = this.appendPropertyIfPresent(stringBuilder, separatorNeeded, "$.ctime", message.getCreationTimeUTCString(), false);
        if (message.isSecurityMessage()) {
            separatorNeeded = this.appendPropertyIfPresent(stringBuilder, separatorNeeded, "$.ifid", "urn:azureiot:Security:SecurityAgent:1", false);
        }
        if (message.getComponentName() != null && !message.getComponentName().isEmpty()) {
            separatorNeeded = this.appendPropertyIfPresent(stringBuilder, separatorNeeded, "$.sub", message.getComponentName(), false);
        }
        for (MessageProperty property : message.getProperties()) {
            separatorNeeded = this.appendPropertyIfPresent(stringBuilder, separatorNeeded, property.getName(), property.getValue(), true);
        }
        if (this.moduleId != null && !this.moduleId.isEmpty()) {
            stringBuilder.append("/");
        }
        String messagePublishTopic = stringBuilder.toString();
        this.publish(messagePublishTopic, message);
    }

    private boolean appendPropertyIfPresent(StringBuilder stringBuilder, boolean separatorNeeded, String propertyKey, String propertyValue, boolean isApplicationProperty) throws TransportException {
        try {
            if (propertyValue != null && !propertyValue.isEmpty()) {
                if (separatorNeeded) {
                    stringBuilder.append('&');
                }
                if (isApplicationProperty) {
                    stringBuilder.append(URLEncoder.encode(propertyKey, StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20"));
                } else {
                    stringBuilder.append(propertyKey);
                }
                stringBuilder.append('=');
                stringBuilder.append(URLEncoder.encode(propertyValue, StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20"));
                return true;
            }
            return separatorNeeded;
        }
        catch (UnsupportedEncodingException e) {
            throw new TransportException("Could not utf-8 encode the property with name " + propertyKey + " and value " + propertyValue, e);
        }
    }
}

