/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.https;

import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageProperty;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

final class HttpsSingleMessage
implements HttpsMessage {
    private static final String HTTPS_SINGLE_MESSAGE_CONTENT_TYPE = "binary/octet-stream";
    private static final String HTTPS_SINGLE_JSON_MESSAGE_CONTENT_TYPE = "application/json;charset=utf-8";
    private static final String CORRELATION_ID_KEY = "iothub-correlationid";
    private static final String MESSAGE_ID_KEY = "iothub-messageid";
    private static final String TO_KEY = "iothub-to";
    private static final String USER_ID_KEY = "iothub-userid";
    private static final String CONTENT_ENCODING_KEY = "iothub-contentencoding";
    private static final String CONTENT_TYPE_KEY = "iothub-contenttype";
    private byte[] body;
    private boolean base64Encoded;
    private MessageProperty[] properties;
    private Map<String, String> systemProperties;
    private String contentType;

    public static HttpsSingleMessage parseHttpsMessage(Message message) {
        HttpsSingleMessage httpsMsg = new HttpsSingleMessage();
        httpsMsg.contentType = HTTPS_SINGLE_MESSAGE_CONTENT_TYPE;
        HttpsSingleMessage.parser(httpsMsg, message);
        return httpsMsg;
    }

    public static HttpsSingleMessage parseHttpsJsonMessage(Message message) {
        HttpsSingleMessage httpsMsg = new HttpsSingleMessage();
        httpsMsg.contentType = HTTPS_SINGLE_JSON_MESSAGE_CONTENT_TYPE;
        HttpsSingleMessage.parser(httpsMsg, message);
        return httpsMsg;
    }

    private static void parser(HttpsSingleMessage httpsMsg, Message message) {
        byte[] msgBody = message.getBytes();
        httpsMsg.body = Arrays.copyOf(msgBody, msgBody.length);
        MessageProperty[] msgProperties = message.getProperties();
        httpsMsg.properties = new MessageProperty[msgProperties.length];
        for (int countProperty = 0; countProperty < msgProperties.length; ++countProperty) {
            MessageProperty property = msgProperties[countProperty];
            httpsMsg.properties[countProperty] = new MessageProperty("iothub-app-" + property.getName(), property.getValue());
        }
        HashMap<String, String> sysProperties = new HashMap<String, String>();
        if (message.getUserId() != null) {
            sysProperties.put(USER_ID_KEY, message.getUserId());
        }
        if (message.getMessageId() != null) {
            sysProperties.put(MESSAGE_ID_KEY, message.getMessageId());
        }
        if (message.getCorrelationId() != null) {
            sysProperties.put(CORRELATION_ID_KEY, message.getCorrelationId());
        }
        if (message.getTo() != null) {
            sysProperties.put(TO_KEY, message.getTo());
        }
        if (message.getContentEncoding() != null) {
            sysProperties.put(CONTENT_ENCODING_KEY, message.getContentEncoding());
        }
        if (message.getContentType() != null) {
            sysProperties.put(CONTENT_TYPE_KEY, message.getContentType());
        }
        httpsMsg.systemProperties = new HashMap<String, String>(sysProperties);
    }

    public static HttpsSingleMessage parseHttpsMessage(HttpsResponse response) {
        HttpsSingleMessage msg = new HttpsSingleMessage();
        byte[] responseBody = response.getBody();
        msg.body = Arrays.copyOf(responseBody, responseBody.length);
        ArrayList<MessageProperty> properties = new ArrayList<MessageProperty>();
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        Map<String, String> headerFields = response.getHeaderFields();
        for (Map.Entry<String, String> field : headerFields.entrySet()) {
            String propertyValue;
            String propertyName = field.getKey();
            if (HttpsSingleMessage.isValidHttpsAppProperty(propertyName, propertyValue = field.getValue())) {
                properties.add(new MessageProperty(propertyName, propertyValue));
                continue;
            }
            if (!HttpsSingleMessage.isValidHttpsSystemProperty(propertyName, propertyValue)) continue;
            String systemPropertyName = propertyName.substring("iothub-".length());
            systemProperties.put("iothub-" + systemPropertyName.toLowerCase(), propertyValue);
        }
        msg.properties = new MessageProperty[properties.size()];
        msg.properties = properties.toArray(msg.properties);
        msg.systemProperties = systemProperties;
        return msg;
    }

    public Message toMessage() {
        Message msg = new Message(this.getBody());
        for (MessageProperty property : this.properties) {
            String propertyName = HttpsSingleMessage.httpsAppPropertyToAppProperty(property.getName());
            String propertyValue = property.getValue();
            msg.setProperty(propertyName, propertyValue);
        }
        if (this.systemProperties.containsKey(MESSAGE_ID_KEY)) {
            msg.setMessageId(this.systemProperties.get(MESSAGE_ID_KEY));
        }
        if (this.systemProperties.containsKey(USER_ID_KEY)) {
            msg.setProperty("iothub-app-iothub-userid", this.systemProperties.get(USER_ID_KEY));
        }
        if (this.systemProperties.containsKey(CORRELATION_ID_KEY)) {
            msg.setCorrelationId(this.systemProperties.get(CORRELATION_ID_KEY));
        }
        if (this.systemProperties.containsKey(CONTENT_TYPE_KEY)) {
            msg.setContentType(this.systemProperties.get(CONTENT_TYPE_KEY));
        }
        if (this.systemProperties.containsKey(CONTENT_ENCODING_KEY)) {
            msg.setContentEncoding(this.systemProperties.get(CONTENT_ENCODING_KEY));
        }
        if (this.systemProperties.containsKey(TO_KEY)) {
            msg.setProperty("iothub-app-iothub-to", this.systemProperties.get(TO_KEY));
        }
        return msg;
    }

    @Override
    public byte[] getBody() {
        return Arrays.copyOf(this.body, this.body.length);
    }

    public String getBodyAsString() {
        return new String(this.body, Message.DEFAULT_IOTHUB_MESSAGE_CHARSET);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public boolean isBase64Encoded() {
        return this.base64Encoded;
    }

    @Override
    public MessageProperty[] getProperties() {
        int propertiesSize = this.properties.length;
        MessageProperty[] propertiesCopy = new MessageProperty[propertiesSize];
        for (int i = 0; i < propertiesSize; ++i) {
            MessageProperty propertyCopy;
            MessageProperty property = this.properties[i];
            propertiesCopy[i] = propertyCopy = new MessageProperty(property.getName(), property.getValue());
        }
        return propertiesCopy;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return new HashMap<String, String>(this.systemProperties);
    }

    private static boolean isValidHttpsAppProperty(String name, String value) {
        String lowercaseName = name.toLowerCase();
        return MessageProperty.isValidAppProperty(name.toLowerCase(), value) && lowercaseName.startsWith("iothub-app-");
    }

    private static boolean isValidHttpsSystemProperty(String name, String value) {
        String lowercaseName = name.toLowerCase();
        return MessageProperty.isValidSystemProperty(name.toLowerCase(), value) && lowercaseName.startsWith("iothub-") && !lowercaseName.startsWith("iothub-app-");
    }

    private static String httpsAppPropertyToAppProperty(String httpsAppProperty) {
        String canonicalizedProperty = httpsAppProperty.toLowerCase();
        if (canonicalizedProperty.startsWith("iothub-app-")) {
            return canonicalizedProperty.substring("iothub-app-".length());
        }
        return canonicalizedProperty;
    }

    private HttpsSingleMessage() {
    }
}

