/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.https;

import com.microsoft.azure.sdk.iot.device.ProxySettings;
import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsConnection;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMethod;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsResponse;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;

public class HttpsRequest {
    private byte[] body;
    private HttpsMethod method;
    private URL url;
    private Map<String, List<String>> headers;
    private int readTimeout;
    private int connectTimeout;
    private SSLContext sslContext;
    private ProxySettings proxySettings;

    public HttpsRequest(URL url, HttpsMethod method, byte[] body, String userAgentString) {
        this(url, method, body, userAgentString, null);
    }

    public HttpsRequest(URL url, HttpsMethod method, byte[] body, String userAgentString, ProxySettings proxySettings) {
        this.url = url;
        this.method = method;
        this.body = body;
        this.headers = new HashMap<String, List<String>>();
        ArrayList<String> hostHeaderValues = new ArrayList<String>();
        if (url != null && url.getHost() != null && !url.getHost().isEmpty()) {
            String host = url.getHost();
            if (url.getPort() != -1) {
                host = host + ":" + url.getPort();
            }
            hostHeaderValues.add(host);
            this.headers.put("Host", hostHeaderValues);
        }
        if (userAgentString != null && !userAgentString.isEmpty()) {
            ArrayList<String> headerValues = new ArrayList<String>();
            headerValues.add(userAgentString);
            this.headers.put("User-Agent", headerValues);
        }
        this.proxySettings = proxySettings;
    }

    public HttpsResponse send() throws TransportException {
        return this.send(true);
    }

    public HttpsResponse sendAsHttpRequest() throws TransportException {
        return this.send(false);
    }

    private HttpsResponse send(boolean isHttps) throws TransportException {
        if (this.url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        HttpsConnection connection = new HttpsConnection(this.url, this.method, this.proxySettings, isHttps);
        for (String headerKey : this.headers.keySet()) {
            for (String headerValue : this.headers.get(headerKey)) {
                connection.setRequestHeader(headerKey, headerValue);
            }
        }
        connection.writeOutput(this.body);
        if (this.sslContext != null && isHttps) {
            connection.setSSLContext(this.sslContext);
        }
        if (this.readTimeout != 0) {
            connection.setReadTimeout(this.readTimeout);
        }
        if (this.connectTimeout != 0) {
            connection.setConnectTimeout(this.connectTimeout);
        }
        byte[] responseBody = new byte[]{};
        byte[] errorReason = new byte[]{};
        connection.connect();
        int responseStatus = connection.getResponseStatus();
        Map<String, List<String>> headerFields = connection.getResponseHeaders();
        if (responseStatus == 200) {
            responseBody = connection.readInput();
        }
        return new HttpsResponse(responseStatus, responseBody, headerFields, errorReason);
    }

    public HttpsRequest setHeaderField(String field, String value) {
        if (this.headers.containsKey(field)) {
            this.headers.get(field).add(value);
        } else {
            ArrayList<String> headerValues = new ArrayList<String>();
            headerValues.add(value);
            this.headers.put(field, headerValues);
        }
        return this;
    }

    public HttpsRequest setReadTimeout(int timeout) {
        this.readTimeout = timeout;
        return this;
    }

    public HttpsRequest setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public HttpsRequest setSSLContext(SSLContext sslContext) throws IllegalArgumentException {
        if (sslContext == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        this.sslContext = sslContext;
        return this;
    }

    public byte[] getBody() {
        return this.body;
    }

    public URL getRequestUrl() {
        return this.url;
    }

    public String getHttpMethod() {
        return this.method.toString();
    }

    public String getRequestHeaders() {
        StringBuilder headerString = new StringBuilder();
        for (String key : this.headers.keySet()) {
            headerString.append(key);
            headerString.append(": ");
            for (String value : this.headers.get(key)) {
                headerString.append(value);
                headerString.append("; ");
            }
            headerString = new StringBuilder(headerString.substring(0, headerString.length() - 2));
            headerString.append("\r\n");
        }
        return headerString.toString();
    }

    protected HttpsRequest() {
    }
}

