/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.https;

import com.microsoft.azure.sdk.iot.device.MessageProperty;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsSingleMessage;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

final class HttpsBatchMessage
implements HttpsMessage {
    private static final int SERVICEBOUND_MESSAGE_MAX_SIZE_BYTES = 261119;
    private static final String HTTPS_BATCH_CONTENT_TYPE = "application/vnd.microsoft.iothub.json";
    private static final Charset BATCH_CHARSET = StandardCharsets.UTF_8;
    private static final String BASE_ENCODED_KEY = "\"base64Encoded\"";
    private static final String BODY = "\"body\"";
    private static final String KEY_VALUE_SEPARATOR = ":";
    private static final String PROPERTIES = "\"properties\"";
    private final String batchBody;
    private int numMsgs;

    public HttpsBatchMessage(List<HttpsSingleMessage> messageList) throws IllegalArgumentException {
        StringBuilder batchBodyBuilder = new StringBuilder();
        batchBodyBuilder.append('[');
        boolean isSubsequentMessage = false;
        for (HttpsSingleMessage message : messageList) {
            if (isSubsequentMessage) {
                batchBodyBuilder.append(',');
            }
            HttpsBatchMessage.addJsonToStringBuilder(message, batchBodyBuilder);
            ++this.numMsgs;
            isSubsequentMessage = true;
        }
        batchBodyBuilder.append(']');
        this.batchBody = batchBodyBuilder.toString();
        byte[] newBatchBodyBytes = this.batchBody.getBytes(BATCH_CHARSET);
        if (newBatchBodyBytes.length > 261119) {
            String errMsg = String.format("Service-bound message size (%d bytes) cannot exceed %d bytes.", newBatchBodyBytes.length, 261119);
            throw new IllegalArgumentException(errMsg);
        }
    }

    @Override
    public byte[] getBody() {
        return this.batchBody.getBytes(BATCH_CHARSET);
    }

    @Override
    public String getContentType() {
        return HTTPS_BATCH_CONTENT_TYPE;
    }

    @Override
    public MessageProperty[] getProperties() {
        return new MessageProperty[0];
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return new HashMap<String, String>();
    }

    public int numMessages() {
        return this.numMsgs;
    }

    private static void addJsonToStringBuilder(HttpsSingleMessage msg, StringBuilder jsonStringBuilder) {
        jsonStringBuilder.append("{\"body\":");
        jsonStringBuilder.append('\"').append(Base64.encodeBase64String((byte[])msg.getBody())).append("\",");
        jsonStringBuilder.append("\"base64Encoded\":");
        jsonStringBuilder.append(true);
        MessageProperty[] properties = msg.getProperties();
        HashMap<String, String> allProperties = new HashMap<String, String>(msg.getSystemProperties());
        for (MessageProperty p : properties) {
            allProperties.put(p.getName(), p.getValue());
        }
        int numProperties = allProperties.size();
        if (numProperties > 0) {
            jsonStringBuilder.append(',');
            jsonStringBuilder.append("\"properties\":");
            jsonStringBuilder.append('{');
            for (String key : allProperties.keySet()) {
                jsonStringBuilder.append('\"').append(key).append("\":");
                jsonStringBuilder.append('\"').append((String)allProperties.get(key)).append("\",");
            }
            jsonStringBuilder.deleteCharAt(jsonStringBuilder.length() - 1);
            jsonStringBuilder.append('}');
        }
        jsonStringBuilder.append('}');
    }
}

