/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpConnectionForcedException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpConnectionFramingErrorException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpConnectionRedirectException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpConnectionThrottledException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpDecodeErrorException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpFrameSizeTooSmallException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpIllegalStateException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpInternalErrorException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpInvalidFieldException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpLinkCreationConflict;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpLinkDetachForcedException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpLinkMessageSizeExceededException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpLinkRedirectException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpLinkStolenException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpLinkTransferLimitExceededException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpNotAllowedException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpNotFoundException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpNotImplementedException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpPreconditionFailedException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpResourceDeletedException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpResourceLimitExceededException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpResourceLockedException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpSessionErrantLinkException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpSessionHandleInUseException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpSessionUnattachedHandleException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpSessionWindowViolationException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.AmqpUnauthorizedAccessException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.exceptions.ProtonIOException;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;

class AmqpsExceptionTranslator {
    AmqpsExceptionTranslator() {
    }

    static TransportException convertFromAmqpException(ErrorCondition error) {
        if (error == null) {
            TransportException t = new TransportException("An unknown transport exception occurred");
            t.setRetryable(true);
            return t;
        }
        String exceptionCode = error.getCondition() != null ? error.getCondition().toString() : "unknown";
        String description = error.getDescription();
        switch (exceptionCode) {
            case "com.microsoft:link-creation-conflict": {
                return new AmqpLinkCreationConflict(description);
            }
            case "amqp:connection:forced": {
                return new AmqpConnectionForcedException(description);
            }
            case "amqp:connection:redirect": {
                return new AmqpConnectionRedirectException(description);
            }
            case "amqp:decode-error": {
                return new AmqpDecodeErrorException(description);
            }
            case "amqp:link:detach-forced": {
                return new AmqpLinkDetachForcedException(description);
            }
            case "amqp:session:errant-link": {
                return new AmqpSessionErrantLinkException(description);
            }
            case "amqp:frame-size-too-small": {
                return new AmqpFrameSizeTooSmallException(description);
            }
            case "amqp:connection:framing-error": {
                return new AmqpConnectionFramingErrorException(description);
            }
            case "amqp:session:handle-in-use": {
                return new AmqpSessionHandleInUseException(description);
            }
            case "amqp:illegal-state": {
                return new AmqpIllegalStateException(description);
            }
            case "amqp:internal-error": {
                return new AmqpInternalErrorException(description);
            }
            case "amqp:invalid-field": {
                return new AmqpInvalidFieldException(description);
            }
            case "amqp:link:redirect": {
                return new AmqpLinkRedirectException(description);
            }
            case "amqp:link:stolen": {
                return new AmqpLinkStolenException(description);
            }
            case "amqp:link:message-size-exceeded": {
                return new AmqpLinkMessageSizeExceededException(description);
            }
            case "amqp:not-allowed": {
                return new AmqpNotAllowedException(description);
            }
            case "amqp:not-found": {
                return new AmqpNotFoundException(description);
            }
            case "amqp:not-implemented": {
                return new AmqpNotImplementedException(description);
            }
            case "amqp:precondition-failed": {
                return new AmqpPreconditionFailedException(description);
            }
            case "amqp:resource-deleted": {
                return new AmqpResourceDeletedException(description);
            }
            case "amqp:resource-limit-exceeded": {
                return new AmqpResourceLimitExceededException(description);
            }
            case "amqp:resource-locked": {
                return new AmqpResourceLockedException(description);
            }
            case "amqp:link:transfer-limit-exceeded": {
                return new AmqpLinkTransferLimitExceededException(description);
            }
            case "amqp:session:unattached-handle": {
                return new AmqpSessionUnattachedHandleException(description);
            }
            case "amqp:unauthorized-access": {
                return new AmqpUnauthorizedAccessException(description);
            }
            case "amqp:session:window-violation": {
                return new AmqpSessionWindowViolationException(description);
            }
            case "com.microsoft:device-container-throttled": {
                return new AmqpConnectionThrottledException(description);
            }
            case "proton:io": {
                return new ProtonIOException(description);
            }
        }
        TransportException t = new TransportException("An unknown transport exception occurred");
        t.setRetryable(true);
        return t;
    }
}

