/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageSentCallback;

public final class IotHubTransportPacket {
    private final Message message;
    private final MessageSentCallback eventCallback;
    private final Object callbackContext;
    private IotHubStatusCode status;
    private final long startTimeMillis;
    private int currentRetryAttempt;
    private final String deviceId;

    public IotHubTransportPacket(Message message, MessageSentCallback eventCallback, Object callbackContext, IotHubStatusCode status, long startTimeMillis, String deviceId) throws IllegalArgumentException {
        if (startTimeMillis < 1L) {
            throw new IllegalArgumentException("start time cannot be 0 or negative");
        }
        if (message == null) {
            throw new IllegalArgumentException("Message cannot be null");
        }
        this.message = message;
        this.eventCallback = eventCallback;
        this.callbackContext = callbackContext;
        this.status = status;
        this.startTimeMillis = startTimeMillis;
        this.deviceId = deviceId;
    }

    public Message getMessage() {
        return this.message;
    }

    public MessageSentCallback getCallback() {
        return this.eventCallback;
    }

    public Object getContext() {
        return this.callbackContext;
    }

    public IotHubStatusCode getStatus() {
        return this.status;
    }

    public void setStatus(IotHubStatusCode status) {
        this.status = status;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public int getCurrentRetryAttempt() {
        return this.currentRetryAttempt;
    }

    public void incrementRetryAttempt() {
        ++this.currentRetryAttempt;
    }

    public String getDeviceId() {
        return this.deviceId;
    }
}

