/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransport;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IotHubReceiveTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(IotHubReceiveTask.class);
    private static final String THREAD_NAME = "azure-iot-sdk-IotHubReceiveTask";
    private final IotHubTransport transport;
    private final String threadNamePrefix;
    private final String threadNameSuffix;
    private final boolean useIdentifiableThreadNames;
    private final Semaphore receiveThreadSemaphore;

    public IotHubReceiveTask(IotHubTransport transport, boolean useIdentifiableThreadNames, String threadNamePrefix, String threadNameSuffix) {
        if (transport == null) {
            throw new IllegalArgumentException("Parameter 'transport' must not be null");
        }
        this.transport = transport;
        this.receiveThreadSemaphore = this.transport.getReceiveThreadSemaphore();
        this.useIdentifiableThreadNames = useIdentifiableThreadNames;
        this.threadNamePrefix = threadNamePrefix;
        this.threadNameSuffix = threadNameSuffix;
    }

    @Override
    public void run() {
        String threadName = "";
        if (this.useIdentifiableThreadNames) {
            String deviceClientId = this.transport.getDeviceClientUniqueIdentifier();
            String connectionId = this.transport.getTransportConnectionId();
            threadName = threadName + deviceClientId + "-Cxn" + connectionId + "-" + THREAD_NAME;
        } else {
            if (this.threadNamePrefix != null && !this.threadNamePrefix.isEmpty()) {
                threadName = threadName + this.threadNamePrefix;
            }
            threadName = threadName + THREAD_NAME;
            if (this.threadNameSuffix != null && !this.threadNameSuffix.isEmpty()) {
                threadName = threadName + this.threadNameSuffix;
            }
        }
        Thread.currentThread().setName(threadName);
        try {
            if (this.transport.getProtocol() != IotHubClientProtocol.HTTPS && !this.transport.hasReceivedMessagesToHandle() && !this.transport.isClosed()) {
                this.receiveThreadSemaphore.acquire();
            }
            this.transport.handleMessage();
        }
        catch (InterruptedException e) {
            log.trace("Interrupted while waiting for work. Thread is now ending.");
        }
        catch (Throwable e) {
            log.warn("Receive task thread encountered exception while processing received messages", e);
        }
    }
}

