/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import com.microsoft.azure.sdk.iot.device.auth.IotHubAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSSLContext;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProviderX509;
import com.microsoft.azure.sdk.iot.provisioning.security.exceptions.SecurityProviderException;
import java.io.IOException;
import javax.net.ssl.SSLContext;

public class IotHubX509HardwareAuthenticationProvider
extends IotHubAuthenticationProvider {
    private final SecurityProviderX509 securityProviderX509;

    public IotHubX509HardwareAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId, SecurityProvider securityProvider) {
        super(hostname, gatewayHostname, deviceId, moduleId);
        if (!(securityProvider instanceof SecurityProviderX509)) {
            throw new IllegalArgumentException("The provided security provider must be of type SecurityProviderX509");
        }
        this.securityProviderX509 = (SecurityProviderX509)securityProvider;
        this.iotHubSSLContext = null;
    }

    @Override
    public SSLContext getSSLContext() throws IOException {
        if (this.iotHubSSLContext == null) {
            try {
                this.iotHubSSLContext = new IotHubSSLContext(this.securityProviderX509.getSSLContext());
            }
            catch (SecurityProviderException e) {
                throw new IOException("Failed to get the SSLContext from the security provider", e);
            }
        }
        return this.iotHubSSLContext.getSSLContext();
    }
}

