/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.IotHubMessageResult;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubConnectionStatus;
import com.microsoft.azure.sdk.iot.device.transport.IotHubListener;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportConnection;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttConnection;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttDeviceMethod;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttDeviceTwin;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttMessageListener;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttMessaging;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLContext;

public class MqttIotHubConnection
implements IotHubTransportConnection,
MqttMessageListener {
    private final Object MQTT_CONNECTION_LOCK = new Object();
    private final DeviceClientConfig config;
    private IotHubConnectionStatus state = IotHubConnectionStatus.DISCONNECTED;
    private String iotHubUserName;
    private String iotHubUserPassword;
    private MqttConnection mqttConnection;
    private static final String WS_SSL_PREFIX = "wss://";
    private static final String WEBSOCKET_RAW_PATH = "/$iothub/websocket";
    private static final String WEBSOCKET_QUERY = "?iothub-no-client-cert=true";
    private static final String SSL_PREFIX = "ssl://";
    private static final String SSL_PORT_SUFFIX = ":8883";
    private static final String API_VERSION = "?api-version=" + TransportUtils.IOTHUB_API_VERSION;
    private String connectionId;
    private IotHubListener listener;
    private CustomLogger logger;
    private MqttMessaging deviceMessaging;
    private MqttDeviceTwin deviceTwin;
    private MqttDeviceMethod deviceMethod;
    private Map<IotHubTransportMessage, Integer> receivedMessagesToAcknowledge = new ConcurrentHashMap<IotHubTransportMessage, Integer>();
    private Map<Integer, Message> unacknowledgedSentMessages = new ConcurrentHashMap<Integer, Message>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MqttIotHubConnection(DeviceClientConfig config) throws IllegalArgumentException {
        Object object = this.MQTT_CONNECTION_LOCK;
        synchronized (object) {
            if (config == null) {
                throw new IllegalArgumentException("The DeviceClientConfig cannot be null.");
            }
            if (config.getIotHubHostname() == null || config.getIotHubHostname().length() == 0) {
                throw new IllegalArgumentException("hostName cannot be null or empty.");
            }
            if (config.getDeviceId() == null || config.getDeviceId().length() == 0) {
                throw new IllegalArgumentException("deviceID cannot be null or empty.");
            }
            if (config.getIotHubName() == null || config.getIotHubName().length() == 0) {
                throw new IllegalArgumentException("hubName cannot be null or empty.");
            }
            this.config = config;
            this.deviceMessaging = null;
            this.deviceMethod = null;
            this.deviceTwin = null;
            this.logger = new CustomLogger(this.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(Queue<DeviceClientConfig> deviceClientConfigs, ScheduledExecutorService scheduledExecutorService) throws TransportException {
        this.connectionId = UUID.randomUUID().toString();
        if (deviceClientConfigs.size() > 1) {
            throw new UnsupportedOperationException("Mqtt does not support Multiplexing");
        }
        Object object = this.MQTT_CONNECTION_LOCK;
        synchronized (object) {
            if (this.state == IotHubConnectionStatus.CONNECTED) {
                return;
            }
            try {
                SSLContext sslContext = this.config.getAuthenticationProvider().getSSLContext();
                if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN) {
                    this.iotHubUserPassword = this.config.getSasTokenAuthentication().getRenewedSasToken(false, false);
                } else if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.X509_CERTIFICATE) {
                    if (this.config.isUseWebsocket()) {
                        throw new UnsupportedOperationException("X509 authentication is not supported over MQTT_WS");
                    }
                    this.iotHubUserPassword = null;
                }
                String clientUserAgentIdentifier = "DeviceClientType=" + URLEncoder.encode(this.config.getProductInfo().getUserAgentString(), "UTF-8").replaceAll("\\+", "%20");
                String clientId = this.config.getDeviceId();
                String moduleId = this.config.getModuleId();
                if (moduleId != null && !moduleId.isEmpty()) {
                    clientId = clientId + "/" + moduleId;
                }
                this.iotHubUserName = this.config.getIotHubHostname() + "/" + clientId + "/" + API_VERSION + "&" + clientUserAgentIdentifier;
                String host = this.config.getGatewayHostname();
                if (host == null || host.isEmpty()) {
                    host = this.config.getIotHubHostname();
                }
                if (this.config.isUseWebsocket()) {
                    String wsServerUri = WS_SSL_PREFIX + host + WEBSOCKET_RAW_PATH + WEBSOCKET_QUERY;
                    this.mqttConnection = new MqttConnection(wsServerUri, clientId, this.iotHubUserName, this.iotHubUserPassword, sslContext);
                } else {
                    String serverUri = SSL_PREFIX + host + SSL_PORT_SUFFIX;
                    this.mqttConnection = new MqttConnection(serverUri, clientId, this.iotHubUserName, this.iotHubUserPassword, sslContext);
                }
                this.deviceMessaging = new MqttMessaging(this.mqttConnection, this.config.getDeviceId(), this.listener, this, this.connectionId, this.config.getModuleId(), this.config.getGatewayHostname() != null && !this.config.getGatewayHostname().isEmpty(), this.unacknowledgedSentMessages);
                this.mqttConnection.setMqttCallback(this.deviceMessaging);
                this.deviceMethod = new MqttDeviceMethod(this.mqttConnection, this.connectionId, this.unacknowledgedSentMessages);
                this.deviceTwin = new MqttDeviceTwin(this.mqttConnection, this.connectionId, this.unacknowledgedSentMessages);
                this.deviceMessaging.start();
                this.state = IotHubConnectionStatus.CONNECTED;
                this.listener.onConnectionEstablished(this.connectionId);
            }
            catch (IOException e) {
                this.state = IotHubConnectionStatus.DISCONNECTED;
                if (this.deviceMethod != null) {
                    this.deviceMethod.stop();
                }
                if (this.deviceTwin != null) {
                    this.deviceTwin.stop();
                }
                if (this.deviceMessaging != null) {
                    this.deviceMessaging.stop();
                }
                throw new TransportException(e);
            }
        }
    }

    @Override
    public void close() throws TransportException {
        if (this.state == IotHubConnectionStatus.DISCONNECTED) {
            return;
        }
        try {
            if (this.deviceMethod != null) {
                this.deviceMethod.stop();
                this.deviceMethod = null;
            }
            if (this.deviceTwin != null) {
                this.deviceTwin.stop();
                this.deviceTwin = null;
            }
            if (this.deviceMessaging != null) {
                this.deviceMessaging.stop();
                this.deviceMessaging = null;
            }
            this.state = IotHubConnectionStatus.DISCONNECTED;
        }
        catch (TransportException e) {
            this.state = IotHubConnectionStatus.DISCONNECTED;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IotHubStatusCode sendEvent(Message message) throws IllegalStateException {
        Object object = this.MQTT_CONNECTION_LOCK;
        synchronized (object) {
            if (message == null || message.getBytes() == null || message.getMessageType() != MessageType.DEVICE_TWIN && message.getMessageType() != MessageType.DEVICE_METHODS && message.getBytes().length == 0) {
                return IotHubStatusCode.BAD_FORMAT;
            }
            if (this.state == IotHubConnectionStatus.DISCONNECTED) {
                throw new IllegalStateException("Cannot send event using a closed MQTT connection");
            }
            IotHubStatusCode result = IotHubStatusCode.OK_EMPTY;
            try {
                if (message.getMessageType() == MessageType.DEVICE_METHODS) {
                    this.deviceMethod.start();
                    this.deviceMethod.send((IotHubTransportMessage)message);
                } else if (message.getMessageType() == MessageType.DEVICE_TWIN) {
                    this.deviceTwin.start();
                    this.deviceTwin.send((IotHubTransportMessage)message);
                } else {
                    this.deviceMessaging.send(message);
                }
            }
            catch (Exception e) {
                result = IotHubStatusCode.ERROR;
            }
            return result;
        }
    }

    private IotHubTransportMessage receiveMessage() throws TransportException {
        IotHubTransportMessage message = this.deviceMethod.receive();
        if (message == null) {
            message = this.deviceTwin.receive();
        }
        if (message == null) {
            message = this.deviceMessaging.receive();
        }
        return message;
    }

    @Override
    public void setListener(IotHubListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IotHubStatusCode sendMessage(Message message) throws TransportException {
        Object object = this.MQTT_CONNECTION_LOCK;
        synchronized (object) {
            if (message == null || message.getBytes() == null || message.getMessageType() != MessageType.DEVICE_TWIN && message.getMessageType() != MessageType.DEVICE_METHODS && message.getBytes().length == 0) {
                return IotHubStatusCode.BAD_FORMAT;
            }
            if (this.state == IotHubConnectionStatus.DISCONNECTED) {
                throw new IllegalStateException("Cannot send event using a closed MQTT connection");
            }
            IotHubStatusCode result = IotHubStatusCode.OK_EMPTY;
            if (message.getMessageType() == MessageType.DEVICE_METHODS) {
                this.deviceMethod.start();
                this.deviceMethod.send((IotHubTransportMessage)message);
            } else if (message.getMessageType() == MessageType.DEVICE_TWIN) {
                this.deviceTwin.start();
                this.deviceTwin.send((IotHubTransportMessage)message);
            } else {
                this.deviceMessaging.send(message);
            }
            return result;
        }
    }

    @Override
    public boolean sendMessageResult(Message message, IotHubMessageResult result) throws TransportException {
        boolean ackSent;
        if (message == null || result == null) {
            throw new TransportException(new IllegalArgumentException("message and result must be non-null"));
        }
        if (!this.receivedMessagesToAcknowledge.containsKey(message)) {
            throw new TransportException(new IllegalArgumentException("Provided message cannot be acknowledged because it was already acknowledged or was never received from service"));
        }
        int messageId = this.receivedMessagesToAcknowledge.get(message);
        if (message.getMessageType() == MessageType.DEVICE_METHODS) {
            this.deviceMethod.start();
            ackSent = this.deviceMethod.sendMessageAcknowledgement(messageId);
        } else if (message.getMessageType() == MessageType.DEVICE_TWIN) {
            this.deviceTwin.start();
            ackSent = this.deviceTwin.sendMessageAcknowledgement(messageId);
        } else {
            ackSent = this.deviceMessaging.sendMessageAcknowledgement(messageId);
        }
        if (ackSent) {
            this.receivedMessagesToAcknowledge.remove(message);
        }
        return ackSent;
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }

    @Override
    public void onMessageArrived(int messageId) {
        IotHubTransportMessage transportMessage = null;
        try {
            transportMessage = this.receiveMessage();
        }
        catch (TransportException e) {
            this.listener.onMessageReceived(null, new TransportException("Failed to receive message from service", e));
            this.logger.LogInfo("Encountered exception while receiving message from Iot Hub over MQTT", new Object[0]);
            this.logger.LogError(e);
        }
        if (transportMessage == null) {
            this.listener.onMessageReceived(null, new TransportException("Message sent from service could not be parsed"));
            this.logger.LogInfo("Message arrived from IoT Hub that could not be parsed. That message has been ignored.", new Object[0]);
        } else {
            this.receivedMessagesToAcknowledge.put(transportMessage, messageId);
            switch (transportMessage.getMessageType()) {
                case DEVICE_TWIN: {
                    transportMessage.setMessageCallback(this.config.getDeviceTwinMessageCallback());
                    transportMessage.setMessageCallbackContext(this.config.getDeviceTwinMessageContext());
                    break;
                }
                case DEVICE_METHODS: {
                    transportMessage.setMessageCallback(this.config.getDeviceMethodsMessageCallback());
                    transportMessage.setMessageCallbackContext(this.config.getDeviceMethodsMessageContext());
                    break;
                }
                case DEVICE_TELEMETRY: {
                    transportMessage.setMessageCallback(this.config.getDeviceTelemetryMessageCallback(transportMessage.getInputName()));
                    transportMessage.setMessageCallbackContext(this.config.getDeviceTelemetryMessageContext(transportMessage.getInputName()));
                    break;
                }
            }
            this.listener.onMessageReceived(transportMessage, null);
        }
    }
}

