/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.DeviceTwin;

import com.microsoft.azure.sdk.iot.deps.serializer.MethodParser;
import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.DeviceIO;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceMethodCallback;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceMethodData;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.IotHubMessageResult;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.ObjectLock;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;

public final class DeviceMethod {
    private DeviceMethodCallback deviceMethodCallback;
    private Object deviceMethodCallbackContext;
    private IotHubEventCallback deviceMethodStatusCallback;
    private Object deviceMethodStatusCallbackContext;
    private final ObjectLock DEVICE_METHOD_LOCK = new ObjectLock();
    private boolean isSubscribed = false;
    private DeviceIO deviceIO;
    private DeviceClientConfig config;
    private final CustomLogger logger = new CustomLogger(this.getClass());

    public DeviceMethod(DeviceIO deviceIO, DeviceClientConfig config, IotHubEventCallback deviceMethodStatusCallback, Object deviceMethodStatusCallbackContext) throws IllegalArgumentException {
        if (deviceIO == null || config == null) {
            throw new IllegalArgumentException("Client or config cannot be null");
        }
        if (deviceMethodStatusCallback == null) {
            throw new IllegalArgumentException("Status call back cannot be null");
        }
        this.deviceIO = deviceIO;
        this.config = config;
        this.deviceMethodStatusCallback = deviceMethodStatusCallback;
        this.deviceMethodStatusCallbackContext = deviceMethodStatusCallbackContext;
        this.config.setDeviceMethodsMessageCallback(new deviceMethodResponseCallback(), null);
    }

    public void subscribeToDeviceMethod(DeviceMethodCallback deviceMethodCallback, Object deviceMethodCallbackContext) throws IllegalArgumentException {
        if (deviceMethodCallback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        this.deviceMethodCallback = deviceMethodCallback;
        this.deviceMethodCallbackContext = deviceMethodCallbackContext;
        if (!this.isSubscribed) {
            IotHubTransportMessage subscribeMessage = new IotHubTransportMessage(new byte[0], MessageType.DEVICE_METHODS);
            subscribeMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_METHOD_SUBSCRIBE_REQUEST);
            subscribeMessage.setConnectionDeviceId(this.config.getDeviceId());
            this.deviceIO.sendEventAsync(subscribeMessage, new deviceMethodRequestMessageCallback(), null, this.config.getDeviceId());
        }
    }

    private final class deviceMethodRequestMessageCallback
    implements IotHubEventCallback {
        private deviceMethodRequestMessageCallback() {
        }

        @Override
        public void execute(IotHubStatusCode responseStatus, Object callbackContext) {
            if (DeviceMethod.this.deviceMethodStatusCallback != null) {
                DeviceMethod.this.deviceMethodStatusCallback.execute(responseStatus, DeviceMethod.this.deviceMethodStatusCallbackContext);
            }
        }
    }

    private final class deviceMethodResponseCallback
    implements MessageCallback {
        DeviceClientConfig nestedConfig;

        private deviceMethodResponseCallback() {
            this.nestedConfig = DeviceMethod.this.config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IotHubMessageResult execute(Message message, Object callbackContext) {
            ObjectLock objectLock = DeviceMethod.this.DEVICE_METHOD_LOCK;
            synchronized (objectLock) {
                IotHubStatusCode iotHubStatus = IotHubStatusCode.ERROR;
                IotHubMessageResult result = IotHubMessageResult.ABANDON;
                if (message.getMessageType() != MessageType.DEVICE_METHODS) {
                    DeviceMethod.this.logger.LogError("Unexpected message type received", new Object[0]);
                    DeviceMethod.this.deviceMethodStatusCallback.execute(iotHubStatus, DeviceMethod.this.deviceMethodStatusCallbackContext);
                    return IotHubMessageResult.ABANDON;
                }
                IotHubTransportMessage methodMessage = (IotHubTransportMessage)message;
                switch (methodMessage.getDeviceOperationType()) {
                    case DEVICE_OPERATION_METHOD_RECEIVE_REQUEST: {
                        if (DeviceMethod.this.deviceMethodCallback != null) {
                            if (!DeviceMethod.this.isSubscribed) {
                                DeviceMethod.this.isSubscribed = true;
                            }
                            try {
                                DeviceMethodData responseData = DeviceMethod.this.deviceMethodCallback.call(methodMessage.getMethodName(), methodMessage.getBytes(), DeviceMethod.this.deviceMethodCallbackContext);
                                if (responseData != null) {
                                    MethodParser methodParserObject = new MethodParser((Object)responseData.getResponseMessage());
                                    IotHubTransportMessage responseMessage = new IotHubTransportMessage(methodParserObject.toJson().getBytes(), MessageType.DEVICE_METHODS);
                                    responseMessage.setRequestId(methodMessage.getRequestId());
                                    responseMessage.setConnectionDeviceId(this.nestedConfig.getDeviceId());
                                    responseMessage.setStatus(String.valueOf(responseData.getStatus()));
                                    responseMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_METHOD_SEND_RESPONSE);
                                    DeviceMethod.this.deviceIO.sendEventAsync(responseMessage, new deviceMethodRequestMessageCallback(), null, this.nestedConfig.getDeviceId());
                                    result = IotHubMessageResult.COMPLETE;
                                    break;
                                }
                                DeviceMethod.this.logger.LogInfo("User callback did not send any data for response", new Object[0]);
                                result = IotHubMessageResult.REJECT;
                                DeviceMethod.this.deviceMethodStatusCallback.execute(iotHubStatus, DeviceMethod.this.deviceMethodStatusCallbackContext);
                            }
                            catch (Exception e) {
                                DeviceMethod.this.logger.LogInfo("User callback did not succeed", new Object[0]);
                                result = IotHubMessageResult.REJECT;
                                DeviceMethod.this.deviceMethodStatusCallback.execute(iotHubStatus, DeviceMethod.this.deviceMethodStatusCallbackContext);
                            }
                            break;
                        }
                        DeviceMethod.this.logger.LogInfo("Received device method request, but device has not setup device method", new Object[0]);
                        break;
                    }
                    default: {
                        DeviceMethod.this.logger.LogError("Received unknown type message for device methods", new Object[0]);
                    }
                }
                return result;
            }
        }
    }
}

