/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.proton.transport.proxy.impl;

import com.microsoft.azure.proton.transport.proxy.ProxyHandler;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;

public class ProxyHandlerImpl
implements ProxyHandler {
    static final String CONNECT_REQUEST = "CONNECT %1$s HTTP/1.1%2$sHost: %1$s%2$sConnection: Keep-Alive%2$s";
    static final String HEADER_FORMAT = "%s: %s";
    static final String NEW_LINE = "\r\n";

    @Override
    public String createProxyRequest(String hostName, Map<String, String> additionalHeaders) {
        StringBuilder connectRequestBuilder = new StringBuilder();
        connectRequestBuilder.append(String.format(Locale.ROOT, CONNECT_REQUEST, hostName, NEW_LINE));
        if (additionalHeaders != null) {
            additionalHeaders.forEach((header, value) -> {
                connectRequestBuilder.append(String.format(HEADER_FORMAT, header, value));
                connectRequestBuilder.append(NEW_LINE);
            });
        }
        connectRequestBuilder.append(NEW_LINE);
        return connectRequestBuilder.toString();
    }

    @Override
    public ProxyHandler.ProxyResponseResult validateProxyResponse(ByteBuffer buffer) {
        int size = buffer.remaining();
        String response = null;
        if (size > 0) {
            String firstLine;
            byte[] responseBytes = new byte[buffer.remaining()];
            buffer.get(responseBytes);
            response = new String(responseBytes, StandardCharsets.UTF_8);
            Scanner responseScanner = new Scanner(response);
            if (responseScanner.hasNextLine() && ((firstLine = responseScanner.nextLine()).toLowerCase().contains("http/1.1") || firstLine.toLowerCase().contains("http/1.0")) && firstLine.contains("200") && firstLine.toLowerCase().contains("connection established")) {
                return new ProxyHandler.ProxyResponseResult(true, null);
            }
        }
        return new ProxyHandler.ProxyResponseResult(false, response);
    }
}

