/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging;

import com.microsoft.windowsazure.messaging.Registration;
import com.microsoft.windowsazure.messaging.Utils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class TemplateRegistration
extends Registration {
    private String mBodyTemplate;

    TemplateRegistration(String notificationHubPath) {
        super(notificationHubPath);
    }

    @Override
    protected void appendCustomPayload(Document doc, Element templateRegistrationDescription) {
        this.appendBodyTemplateNode(doc, templateRegistrationDescription);
        this.appendNodeWithValue(doc, templateRegistrationDescription, "TemplateName", this.getName());
    }

    private void appendBodyTemplateNode(Document doc, Element templateRegistrationDescription) {
        if (!Utils.isNullOrWhiteSpace(this.getBodyTemplate())) {
            Element bodyTemplate = doc.createElement("BodyTemplate");
            templateRegistrationDescription.appendChild(bodyTemplate);
            CDATASection bodyTemplateCDATA = doc.createCDATASection(this.getBodyTemplate());
            bodyTemplate.appendChild(bodyTemplateCDATA);
        }
    }

    @Override
    protected void loadCustomXmlData(Element payloadNode) {
        NodeList bodyTemplateElements = payloadNode.getElementsByTagName("BodyTemplate");
        if (bodyTemplateElements.getLength() > 0) {
            NodeList bodyNodes = bodyTemplateElements.item(0).getChildNodes();
            for (int i = 0; i < bodyNodes.getLength(); ++i) {
                if (!(bodyNodes.item(i) instanceof CharacterData)) continue;
                CharacterData data = (CharacterData)bodyNodes.item(i);
                this.mBodyTemplate = data.getData();
                break;
            }
        }
        this.setName(TemplateRegistration.getNodeValue(payloadNode, "TemplateName"));
    }

    public String getBodyTemplate() {
        return this.mBodyTemplate;
    }

    void setBodyTemplate(String bodyTemplate) {
        this.mBodyTemplate = bodyTemplate;
    }

    public String getTemplateName() {
        return this.getName();
    }
}

