/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.ClaimsRequest;
import com.microsoft.aad.msal4j.IApiParameters;
import com.microsoft.aad.msal4j.ParameterValidationUtils;
import java.util.Set;
import lombok.NonNull;

public class RefreshTokenParameters
implements IApiParameters {
    @NonNull
    private Set<String> scopes;
    private ClaimsRequest claims;
    @NonNull
    private String refreshToken;

    private static RefreshTokenParametersBuilder builder() {
        return new RefreshTokenParametersBuilder();
    }

    public static RefreshTokenParametersBuilder builder(Set<String> scopes, String refreshToken) {
        ParameterValidationUtils.validateNotBlank("refreshToken", refreshToken);
        return RefreshTokenParameters.builder().scopes(scopes).refreshToken(refreshToken);
    }

    @Override
    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    @Override
    public ClaimsRequest claims() {
        return this.claims;
    }

    @NonNull
    public String refreshToken() {
        return this.refreshToken;
    }

    private RefreshTokenParameters(@NonNull Set<String> scopes, ClaimsRequest claims, @NonNull String refreshToken) {
        if (scopes == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        if (refreshToken == null) {
            throw new NullPointerException("refreshToken is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.claims = claims;
        this.refreshToken = refreshToken;
    }

    public static class RefreshTokenParametersBuilder {
        private Set<String> scopes;
        private ClaimsRequest claims;
        private String refreshToken;

        RefreshTokenParametersBuilder() {
        }

        public RefreshTokenParametersBuilder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public RefreshTokenParametersBuilder claims(ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        public RefreshTokenParametersBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public RefreshTokenParameters build() {
            return new RefreshTokenParameters(this.scopes, this.claims, this.refreshToken);
        }

        public String toString() {
            return "RefreshTokenParameters.RefreshTokenParametersBuilder(scopes=" + this.scopes + ", claims=" + this.claims + ", refreshToken=" + this.refreshToken + ")";
        }
    }
}

