// Generated by delombok at Tue Feb 02 17:49:08 UTC 2021
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import java.net.URL;

class B2CAuthority extends Authority {
    private static final String AUTHORIZATION_ENDPOINT = "/oauth2/v2.0/authorize";
    private static final String TOKEN_ENDPOINT = "/oauth2/v2.0/token";
    private static final String B2C_AUTHORIZATION_ENDPOINT_FORMAT = "https://%s/%s/%s" + AUTHORIZATION_ENDPOINT;
    private static final String B2C_TOKEN_ENDPOINT_FORMAT = "https://%s/%s" + TOKEN_ENDPOINT + "?p=%s";
    private String policy;

    B2CAuthority(final URL authorityUrl) {
        super(authorityUrl, AuthorityType.B2C);
        setAuthorityProperties();
    }

    private void validatePathSegments(String[] segments) {
        if (segments.length < 3) {
            throw new IllegalArgumentException("B2C \'authority\' Uri should have at least 3 segments in the path (i.e. https://<host>/tfp/<tenant>/<policy>/...)");
        }
    }

    private void setAuthorityProperties() {
        String[] segments = canonicalAuthorityUrl.getPath().substring(1).split("/");
        validatePathSegments(segments);
        policy = segments[2];
        final String b2cAuthorityFormat = "https://%s/%s/%s/%s/";
        this.authority = String.format(b2cAuthorityFormat, canonicalAuthorityUrl.getAuthority(), segments[0], segments[1], segments[2]);
        this.authorizationEndpoint = String.format(B2C_AUTHORIZATION_ENDPOINT_FORMAT, host, tenant, policy);
        this.tokenEndpoint = String.format(B2C_TOKEN_ENDPOINT_FORMAT, host, tenant, policy);
        this.selfSignedJwtAudience = this.tokenEndpoint;
    }

    @java.lang.SuppressWarnings("all")
    String policy() {
        return this.policy;
    }
}
