/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.aad.msal4j.RequestedClaim;
import com.microsoft.aad.msal4j.RequestedClaimAdditionalInfo;
import java.util.ArrayList;
import java.util.List;

public class ClaimsRequest {
    List<RequestedClaim> idTokenRequestedClaims = new ArrayList<RequestedClaim>();
    List<RequestedClaim> userInfoRequestedClaims = new ArrayList<RequestedClaim>();
    List<RequestedClaim> accessTokenRequestedClaims = new ArrayList<RequestedClaim>();

    public void requestClaimInIdToken(String claim, RequestedClaimAdditionalInfo requestedClaimAdditionalInfo) {
        this.idTokenRequestedClaims.add(new RequestedClaim(claim, requestedClaimAdditionalInfo));
    }

    protected void requestClaimInAccessToken(String claim, RequestedClaimAdditionalInfo requestedClaimAdditionalInfo) {
        this.accessTokenRequestedClaims.add(new RequestedClaim(claim, requestedClaimAdditionalInfo));
    }

    public String formatAsJSONString() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        if (!this.idTokenRequestedClaims.isEmpty()) {
            rootNode.set("id_token", (JsonNode)this.convertClaimsToObjectNode(this.idTokenRequestedClaims));
        }
        if (!this.userInfoRequestedClaims.isEmpty()) {
            rootNode.set("userinfo", (JsonNode)this.convertClaimsToObjectNode(this.userInfoRequestedClaims));
        }
        if (!this.accessTokenRequestedClaims.isEmpty()) {
            rootNode.set("access_token", (JsonNode)this.convertClaimsToObjectNode(this.accessTokenRequestedClaims));
        }
        return mapper.valueToTree((Object)rootNode).toString();
    }

    private ObjectNode convertClaimsToObjectNode(List<RequestedClaim> claims) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode claimsNode = mapper.createObjectNode();
        for (RequestedClaim claim : claims) {
            claimsNode.setAll((ObjectNode)mapper.valueToTree((Object)claim));
        }
        return claimsNode;
    }

    public List<RequestedClaim> getIdTokenRequestedClaims() {
        return this.idTokenRequestedClaims;
    }

    public void setIdTokenRequestedClaims(List<RequestedClaim> idTokenRequestedClaims) {
        this.idTokenRequestedClaims = idTokenRequestedClaims;
    }
}

