/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AuthorizationRequestUrlParameters;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.InteractiveRequestParameters;
import com.microsoft.aad.msal4j.MsalClientException;
import com.microsoft.aad.msal4j.MsalRequest;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.RequestContext;
import com.microsoft.aad.msal4j.StringHelper;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

class InteractiveRequest
extends MsalRequest {
    private AtomicReference<CompletableFuture<IAuthenticationResult>> futureReference;
    private InteractiveRequestParameters interactiveRequestParameters;
    private String verifier;
    private String state;
    private PublicClientApplication publicClientApplication;
    private URL authorizationUrl;

    InteractiveRequest(InteractiveRequestParameters parameters, AtomicReference<CompletableFuture<IAuthenticationResult>> futureReference, PublicClientApplication publicClientApplication, RequestContext requestContext) {
        super(publicClientApplication, null, requestContext);
        this.interactiveRequestParameters = parameters;
        this.futureReference = futureReference;
        this.publicClientApplication = publicClientApplication;
        this.validateRedirectUrl(parameters.redirectUri());
    }

    URL authorizationUrl() {
        if (this.authorizationUrl == null) {
            this.authorizationUrl = this.createAuthorizationUrl();
        }
        return this.authorizationUrl;
    }

    private void validateRedirectUrl(URI redirectUri) {
        try {
            if (!InetAddress.getByName(redirectUri.getHost()).isLoopbackAddress()) {
                throw new MsalClientException(String.format("Only loopback redirect uri is supported, but %s was found Configure http://localhost or http://localhost:port both during app registrationand when you create the create the InteractiveRequestParameters object", redirectUri.getHost()), "loopback_redirect_uri");
            }
            if (!redirectUri.getScheme().equals("http")) {
                throw new MsalClientException(String.format("Only http uri scheme is supported but %s was found. Configure http://localhostor http://localhost:port both during app registration and when you create the create the InteractiveRequestParameters object", redirectUri.toString()), "loopback_redirect_uri");
            }
        }
        catch (Exception exception) {
            throw new MsalClientException(exception);
        }
    }

    private URL createAuthorizationUrl() {
        AuthorizationRequestUrlParameters.Builder authorizationRequestUrlBuilder = AuthorizationRequestUrlParameters.builder(this.interactiveRequestParameters.redirectUri().toString(), this.interactiveRequestParameters.scopes()).prompt(this.interactiveRequestParameters.prompt()).claimsChallenge(this.interactiveRequestParameters.claimsChallenge()).loginHint(this.interactiveRequestParameters.loginHint()).domainHint(this.interactiveRequestParameters.domainHint()).correlationId(this.publicClientApplication.correlationId());
        this.addPkceAndState(authorizationRequestUrlBuilder);
        return this.publicClientApplication.getAuthorizationRequestUrl(authorizationRequestUrlBuilder.build());
    }

    private void addPkceAndState(AuthorizationRequestUrlParameters.Builder builder) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] randomBytes = new byte[32];
        secureRandom.nextBytes(randomBytes);
        this.verifier = Base64.getUrlEncoder().withoutPadding().encodeToString(randomBytes);
        this.state = UUID.randomUUID().toString() + UUID.randomUUID().toString();
        builder.codeChallenge(StringHelper.createBase64EncodedSha256Hash(this.verifier)).codeChallengeMethod("S256").state(this.state);
    }

    AtomicReference<CompletableFuture<IAuthenticationResult>> futureReference() {
        return this.futureReference;
    }

    InteractiveRequestParameters interactiveRequestParameters() {
        return this.interactiveRequestParameters;
    }

    String verifier() {
        return this.verifier;
    }

    String state() {
        return this.state;
    }
}

