// Generated by delombok at Mon Sep 28 05:50:24 UTC 2020
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import java.util.UUID;

class RequestContext {
    private String telemetryRequestId;
    private String clientId;
    private String correlationId;
    private PublicApi publicApi;
    private String applicationName;
    private String applicationVersion;
    private String authority;
    private IApiParameters apiParameters;
    private IClientApplicationBase clientApplication;

    public RequestContext(AbstractClientApplicationBase clientApplication, PublicApi publicApi, IApiParameters apiParameters) {
        this.clientApplication = clientApplication;
        this.clientId = StringHelper.isBlank(clientApplication.clientId()) ? "unset_client_id" : clientApplication.clientId();
        this.correlationId = StringHelper.isBlank(clientApplication.correlationId()) ? generateNewCorrelationId() : clientApplication.correlationId();
        this.applicationVersion = clientApplication.applicationVersion();
        this.applicationName = clientApplication.applicationName();
        this.publicApi = publicApi;
        this.authority = clientApplication.authority();
        this.apiParameters = apiParameters;
    }

    private static String generateNewCorrelationId() {
        return UUID.randomUUID().toString();
    }

    @java.lang.SuppressWarnings("all")
    String telemetryRequestId() {
        return this.telemetryRequestId;
    }

    @java.lang.SuppressWarnings("all")
    String clientId() {
        return this.clientId;
    }

    @java.lang.SuppressWarnings("all")
    String correlationId() {
        return this.correlationId;
    }

    @java.lang.SuppressWarnings("all")
    PublicApi publicApi() {
        return this.publicApi;
    }

    @java.lang.SuppressWarnings("all")
    String applicationName() {
        return this.applicationName;
    }

    @java.lang.SuppressWarnings("all")
    String applicationVersion() {
        return this.applicationVersion;
    }

    @java.lang.SuppressWarnings("all")
    String authority() {
        return this.authority;
    }

    @java.lang.SuppressWarnings("all")
    IApiParameters apiParameters() {
        return this.apiParameters;
    }

    @java.lang.SuppressWarnings("all")
    IClientApplicationBase clientApplication() {
        return this.clientApplication;
    }

    @java.lang.SuppressWarnings("all")
    RequestContext telemetryRequestId(final String telemetryRequestId) {
        this.telemetryRequestId = telemetryRequestId;
        return this;
    }
}
