/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.CurrentRequest;
import com.microsoft.aad.msal4j.StringHelper;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

class ServerSideTelemetry {
    private static final String SCHEMA_VERSION = "2";
    private static final String SCHEMA_PIPE_DELIMITER = "|";
    private static final String SCHEMA_COMMA_DELIMITER = ",";
    private static final String CURRENT_REQUEST_HEADER_NAME = "x-client-current-telemetry";
    private static final String LAST_REQUEST_HEADER_NAME = "x-client-last-telemetry";
    private CurrentRequest currentRequest;
    private AtomicInteger silentSuccessfulCount = new AtomicInteger(0);
    ConcurrentMap<String, String[]> previousRequests = new ConcurrentHashMap<String, String[]>();
    ConcurrentMap<String, String[]> previousRequestInProgress = new ConcurrentHashMap<String, String[]>();

    ServerSideTelemetry() {
    }

    synchronized Map<String, String> getServerTelemetryHeaderMap() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put(CURRENT_REQUEST_HEADER_NAME, this.buildCurrentRequestHeader());
        headerMap.put(LAST_REQUEST_HEADER_NAME, this.buildLastRequestHeader());
        return headerMap;
    }

    void addFailedRequestTelemetry(String publicApiId, String correlationId, String error) {
        String[] previousRequest = new String[]{publicApiId, error};
        this.previousRequests.put(correlationId, previousRequest);
    }

    void incrementSilentSuccessfulCount() {
        this.silentSuccessfulCount.incrementAndGet();
    }

    synchronized CurrentRequest getCurrentRequest() {
        return this.currentRequest;
    }

    synchronized void setCurrentRequest(CurrentRequest currentRequest) {
        this.currentRequest = currentRequest;
    }

    private synchronized String buildCurrentRequestHeader() {
        if (this.currentRequest == null) {
            return StringHelper.EMPTY_STRING;
        }
        return "2|" + this.currentRequest.publicApi().getApiId() + SCHEMA_COMMA_DELIMITER + this.currentRequest.forceRefresh() + SCHEMA_PIPE_DELIMITER;
    }

    private synchronized String buildLastRequestHeader() {
        StringBuilder lastRequestBuilder = new StringBuilder();
        lastRequestBuilder.append(SCHEMA_VERSION).append(SCHEMA_PIPE_DELIMITER).append(this.silentSuccessfulCount.getAndSet(0));
        if (this.previousRequests.isEmpty()) {
            return lastRequestBuilder.append(SCHEMA_PIPE_DELIMITER).append(SCHEMA_PIPE_DELIMITER).append(SCHEMA_PIPE_DELIMITER).toString();
        }
        StringBuilder middleSegmentBuilder = new StringBuilder(SCHEMA_PIPE_DELIMITER);
        StringBuilder errorSegmentBuilder = new StringBuilder(SCHEMA_PIPE_DELIMITER);
        Iterator it = this.previousRequests.keySet().iterator();
        while (it.hasNext() && middleSegmentBuilder.length() + errorSegmentBuilder.length() < 3800) {
            String correlationId = (String)it.next();
            String[] previousRequest = (String[])this.previousRequests.get(correlationId);
            String apiId = (String)Array.get(previousRequest, 0);
            String error = (String)Array.get(previousRequest, 1);
            middleSegmentBuilder.append(apiId).append(SCHEMA_COMMA_DELIMITER).append(correlationId);
            errorSegmentBuilder.append(error);
            if (it.hasNext()) {
                middleSegmentBuilder.append(SCHEMA_COMMA_DELIMITER);
                errorSegmentBuilder.append(SCHEMA_COMMA_DELIMITER);
            }
            this.previousRequestInProgress.put(correlationId, previousRequest);
            it.remove();
        }
        errorSegmentBuilder.append(SCHEMA_PIPE_DELIMITER);
        return lastRequestBuilder.append((CharSequence)middleSegmentBuilder).append((CharSequence)errorSegmentBuilder).toString();
    }
}

