// Generated by delombok at Mon Sep 07 03:00:24 UTC 2020
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotBlank;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotEmpty;

/**
 * Object containing parameters for refresh token request. Can be used as parameter to

 * {@link PublicClientApplication#acquireToken(RefreshTokenParameters)} or to

 * {@link ConfidentialClientApplication#acquireToken(RefreshTokenParameters)}

 *

 *  RefreshTokenParameters should only be used for migration scenarios (when moving from ADAL to

 *  MSAL). To acquire tokens silently, use {@link AbstractClientApplicationBase#acquireTokenSilently(SilentParameters)}
 */
public class RefreshTokenParameters implements IApiParameters {
    /**
     * Scopes the application is requesting access to
     */
    @NonNull
    private Set<String> scopes;
    /**
     * Refresh token received from the STS
     */
    @NonNull
    private String refreshToken;

    private static RefreshTokenParametersBuilder builder() {
        return new RefreshTokenParametersBuilder();
    }

    /**
     * Builder for {@link RefreshTokenParameters}

     * @param scopes scopes application is requesting access to

     * @param refreshToken refresh token received form the STS

     * @return builder object that can be used to construct {@link RefreshTokenParameters}
     */
    public static RefreshTokenParametersBuilder builder(Set<String> scopes, String refreshToken) {
        validateNotBlank("refreshToken", refreshToken);
        return builder().scopes(scopes).refreshToken(refreshToken);
    }


    @java.lang.SuppressWarnings("all")
    public static class RefreshTokenParametersBuilder {
        @java.lang.SuppressWarnings("all")
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        private String refreshToken;

        @java.lang.SuppressWarnings("all")
        RefreshTokenParametersBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public RefreshTokenParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public RefreshTokenParametersBuilder refreshToken(final String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public RefreshTokenParameters build() {
            return new RefreshTokenParameters(scopes, refreshToken);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "RefreshTokenParameters.RefreshTokenParametersBuilder(scopes=" + this.scopes + ", refreshToken=" + this.refreshToken + ")";
        }
    }

    /**
     * Scopes the application is requesting access to
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Refresh token received from the STS
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    public String refreshToken() {
        return this.refreshToken;
    }

    @java.lang.SuppressWarnings("all")
    private RefreshTokenParameters(@NonNull final Set<String> scopes, @NonNull final String refreshToken) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked @NonNull but is null");
        }
        if (refreshToken == null) {
            throw new java.lang.NullPointerException("refreshToken is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.refreshToken = refreshToken;
    }
}
