// Generated by delombok at Mon Sep 07 03:00:24 UTC 2020
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotEmpty;

/**
 * Object containing parameters for On-Behalf-Of flow. Can be used as parameter to

 * {@link ConfidentialClientApplication#acquireToken(OnBehalfOfParameters)}

 *

 * For more details, see https://aka.ms/msal4j-on-behalf-of
 */
public class OnBehalfOfParameters implements IApiParameters {
    @NonNull
    private Set<String> scopes;
    @NonNull
    private IUserAssertion userAssertion;

    private static OnBehalfOfParametersBuilder builder() {
        return new OnBehalfOfParametersBuilder();
    }

    /**
     * Builder for {@link OnBehalfOfParameters}

     * @param scopes scopes application is requesting access to

     * @param userAssertion {@link UserAssertion} created from access token received

     * @return builder that can be used to construct OnBehalfOfParameters
     */
    public static OnBehalfOfParametersBuilder builder(Set<String> scopes, UserAssertion userAssertion) {
        validateNotEmpty("scopes", scopes);
        return builder().scopes(scopes).userAssertion(userAssertion);
    }


    @java.lang.SuppressWarnings("all")
    public static class OnBehalfOfParametersBuilder {
        @java.lang.SuppressWarnings("all")
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        private IUserAssertion userAssertion;

        @java.lang.SuppressWarnings("all")
        OnBehalfOfParametersBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public OnBehalfOfParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public OnBehalfOfParametersBuilder userAssertion(final IUserAssertion userAssertion) {
            this.userAssertion = userAssertion;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public OnBehalfOfParameters build() {
            return new OnBehalfOfParameters(scopes, userAssertion);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "OnBehalfOfParameters.OnBehalfOfParametersBuilder(scopes=" + this.scopes + ", userAssertion=" + this.userAssertion + ")";
        }
    }

    @NonNull
    @java.lang.SuppressWarnings("all")
    public Set<String> scopes() {
        return this.scopes;
    }

    @NonNull
    @java.lang.SuppressWarnings("all")
    public IUserAssertion userAssertion() {
        return this.userAssertion;
    }

    @java.lang.SuppressWarnings("all")
    private OnBehalfOfParameters(@NonNull final Set<String> scopes, @NonNull final IUserAssertion userAssertion) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked @NonNull but is null");
        }
        if (userAssertion == null) {
            throw new java.lang.NullPointerException("userAssertion is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.userAssertion = userAssertion;
    }
}
