/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.IApiParameters;
import com.microsoft.aad.msal4j.ParameterValidationUtils;
import java.beans.ConstructorProperties;
import java.util.Set;
import lombok.NonNull;

public class ClientCredentialParameters
implements IApiParameters {
    @NonNull
    private Set<String> scopes;

    private static ClientCredentialParametersBuilder builder() {
        return new ClientCredentialParametersBuilder();
    }

    public static ClientCredentialParametersBuilder builder(Set<String> scopes) {
        ParameterValidationUtils.validateNotEmpty("scopes", scopes);
        return ClientCredentialParameters.builder().scopes(scopes);
    }

    @Override
    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    @ConstructorProperties(value={"scopes"})
    private ClientCredentialParameters(@NonNull Set<String> scopes) {
        if (scopes == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        this.scopes = scopes;
    }

    public static class ClientCredentialParametersBuilder {
        private Set<String> scopes;

        ClientCredentialParametersBuilder() {
        }

        public ClientCredentialParametersBuilder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public ClientCredentialParameters build() {
            return new ClientCredentialParameters(this.scopes);
        }

        public String toString() {
            return "ClientCredentialParameters.ClientCredentialParametersBuilder(scopes=" + this.scopes + ")";
        }
    }
}

