/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AadInstanceDiscovery;
import com.microsoft.aad.msal4j.ApiEvent;
import com.microsoft.aad.msal4j.AuthenticationResult;
import com.microsoft.aad.msal4j.Authority;
import com.microsoft.aad.msal4j.ClientApplicationBase;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.HttpHeaders;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.InstanceDiscoveryMetadataEntry;
import com.microsoft.aad.msal4j.LogHelper;
import com.microsoft.aad.msal4j.MsalRequest;
import com.microsoft.aad.msal4j.MsalServiceException;
import com.microsoft.aad.msal4j.StringHelper;
import com.microsoft.aad.msal4j.TelemetryHelper;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import org.apache.commons.codec.binary.Base64;

abstract class AuthenticationResultSupplier
implements Supplier<IAuthenticationResult> {
    ClientApplicationBase clientApplication;
    MsalRequest msalRequest;

    AuthenticationResultSupplier(ClientApplicationBase clientApplication, MsalRequest msalRequest) {
        this.clientApplication = clientApplication;
        this.msalRequest = msalRequest;
    }

    Authority getAuthorityWithPrefNetworkHost(String authority) throws Exception {
        URL authorityUrl = new URL(authority);
        InstanceDiscoveryMetadataEntry discoveryMetadataEntry = AadInstanceDiscovery.GetMetadataEntry(authorityUrl, this.clientApplication.validateAuthority(), this.msalRequest, this.clientApplication.getServiceBundle());
        URL updatedAuthorityUrl = new URL(authorityUrl.getProtocol(), discoveryMetadataEntry.preferredNetwork, authorityUrl.getFile());
        return Authority.createAuthority(updatedAuthorityUrl);
    }

    abstract AuthenticationResult execute() throws Exception;

    @Override
    public IAuthenticationResult get() {
        AuthenticationResult result;
        ApiEvent apiEvent = this.initializeApiEvent(this.msalRequest);
        try (TelemetryHelper telemetryHelper = this.clientApplication.getServiceBundle().getTelemetryManager().createTelemetryHelper(this.msalRequest.requestContext().telemetryRequestId(), this.msalRequest.application().clientId(), apiEvent, true);){
            try {
                result = this.execute();
                apiEvent.setWasSuccessful(true);
                if (result != null) {
                    this.logResult(result, this.msalRequest.headers());
                    if (result.account() != null) {
                        apiEvent.setTenantId(result.accountCacheEntity().realm());
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof MsalServiceException) {
                    apiEvent.setApiErrorCode(((MsalServiceException)ex).errorCode());
                }
                this.clientApplication.log.error(LogHelper.createMessage("Execution of " + this.getClass() + " failed.", this.msalRequest.headers().getHeaderCorrelationIdValue()), (Throwable)ex);
                throw new CompletionException(ex);
            }
        }
        return result;
    }

    void logResult(AuthenticationResult result, HttpHeaders headers) {
        if (!StringHelper.isBlank(result.accessToken())) {
            String accessTokenHash = this.computeSha256Hash(result.accessToken());
            if (!StringHelper.isBlank(result.refreshToken())) {
                String refreshTokenHash = this.computeSha256Hash(result.refreshToken());
                if (this.clientApplication.logPii()) {
                    this.clientApplication.log.debug(LogHelper.createMessage(String.format("Access Token with hash '%s' and Refresh Token with hash '%s' returned", accessTokenHash, refreshTokenHash), headers.getHeaderCorrelationIdValue()));
                } else {
                    this.clientApplication.log.debug(LogHelper.createMessage("Access Token and Refresh Token were returned", headers.getHeaderCorrelationIdValue()));
                }
            } else if (this.clientApplication.logPii()) {
                this.clientApplication.log.debug(LogHelper.createMessage(String.format("Access Token with hash '%s' returned", accessTokenHash), headers.getHeaderCorrelationIdValue()));
            } else {
                this.clientApplication.log.debug(LogHelper.createMessage("Access Token was returned", headers.getHeaderCorrelationIdValue()));
            }
        }
    }

    private ApiEvent initializeApiEvent(MsalRequest msalRequest) {
        ApiEvent apiEvent = new ApiEvent(this.clientApplication.logPii());
        msalRequest.requestContext().telemetryRequestId(this.clientApplication.getServiceBundle().getTelemetryManager().generateRequestId());
        apiEvent.setApiId(msalRequest.requestContext().publicApi().getApiId());
        apiEvent.setCorrelationId(msalRequest.requestContext().correlationId());
        apiEvent.setRequestId(msalRequest.requestContext().telemetryRequestId());
        apiEvent.setWasSuccessful(false);
        if (this.clientApplication instanceof ConfidentialClientApplication) {
            apiEvent.setIsConfidentialClient(true);
        } else {
            apiEvent.setIsConfidentialClient(false);
        }
        try {
            Authority authenticationAuthority = this.clientApplication.authenticationAuthority;
            if (authenticationAuthority != null) {
                apiEvent.setAuthority(new URI(authenticationAuthority.authority()));
                apiEvent.setAuthorityType(authenticationAuthority.authorityType().toString());
            }
        }
        catch (URISyntaxException ex) {
            this.clientApplication.log.warn(LogHelper.createMessage("Setting URL telemetry fields failed: " + LogHelper.getPiiScrubbedDetails(ex), msalRequest.headers().getHeaderCorrelationIdValue()));
        }
        return apiEvent;
    }

    private String computeSha256Hash(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(input.getBytes("UTF-8"));
            byte[] hash = digest.digest();
            return Base64.encodeBase64URLSafeString((byte[])hash);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            this.clientApplication.log.warn(LogHelper.createMessage("Failed to compute SHA-256 hash due to exception - ", LogHelper.getPiiScrubbedDetails(ex)));
            return "Failed to compute SHA-256 hash";
        }
    }
}

